/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.wixie;

import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

public class FarmerDelightRecipeWrappers {

    public static class PotRecipeWrapper
    extends MultiRecipeWrapper {
        public static Map<Item, MultiRecipeWrapper> RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();

        public static MultiRecipeWrapper fromStack(ItemStack stack, Level level) {
            MultiRecipeWrapper wrapper = new MultiRecipeWrapper();
            if (RECIPE_CACHE.containsKey(stack.getItem())) {
                return RECIPE_CACHE.get(stack.getItem());
            }
            if (level.getServer() == null) {
                return wrapper;
            }
            for (RecipeHolder r : level.getServer().getRecipeManager().getRecipes()) {
                CookingPotRecipe cookingPotRecipe;
                Recipe recipe = r.value();
                if (!(recipe instanceof CookingPotRecipe) || (cookingPotRecipe = (CookingPotRecipe)recipe).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() != stack.getItem()) continue;
                ArrayList<Ingredient> extended_ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)cookingPotRecipe.getIngredients());
                if (!cookingPotRecipe.getOutputContainer().isEmpty()) {
                    extended_ingredients.add(Ingredient.of((ItemStack[])new ItemStack[]{cookingPotRecipe.getOutputContainer()}));
                }
                wrapper.addRecipe(extended_ingredients, cookingPotRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (Recipe)cookingPotRecipe);
            }
            RECIPE_CACHE.put(stack.getItem(), wrapper);
            return wrapper;
        }
    }

    public static class CuttingRecipeWrapper
    extends MultiRecipeWrapper {
        public static Map<Item, MultiRecipeWrapper> RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();

        public static MultiRecipeWrapper fromStack(ItemStack stack, Level level) {
            MultiRecipeWrapper wrapper = new MultiRecipeWrapper();
            if (RECIPE_CACHE.containsKey(stack.getItem())) {
                return RECIPE_CACHE.get(stack.getItem());
            }
            if (level.getServer() == null) {
                return wrapper;
            }
            for (RecipeHolder r : level.getServer().getRecipeManager().getRecipes()) {
                Recipe recipe = r.value();
                if (!(recipe instanceof CuttingBoardRecipe)) continue;
                CuttingBoardRecipe cuttingBoardRecipe = (CuttingBoardRecipe)recipe;
                if (r.value().getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() != stack.getItem()) continue;
                wrapper.addRecipe((List)cuttingBoardRecipe.getIngredients(), cuttingBoardRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (Recipe)cuttingBoardRecipe);
            }
            RECIPE_CACHE.put(stack.getItem(), wrapper);
            return wrapper;
        }
    }
}

