/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle;

import alexthw.starbunclemania.starbuncle.StarbyItemBehavior;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class StoreItemGoal<T extends StarbyItemBehavior>
extends GoToPosGoal<T> {
    public StoreItemGoal(Starbuncle starbuncle, T behavior) {
        super(starbuncle, behavior, () -> !behavior.isBedPowered() && !starbuncle.getHeldStack().isEmpty());
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    public BlockPos getDestination() {
        return ((StarbyItemBehavior)this.behavior).getValidStorePos(this.starbuncle.getHeldStack());
    }

    public boolean onDestinationReached() {
        this.starbuncle.getNavigation().stop();
        Level world = this.starbuncle.level();
        BlockEntity tileEntity = world.getBlockEntity(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("missing_tile", "store pos broken " + this.targetPos.toString()));
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            return true;
        }
        IItemHandler iItemHandler = ((StarbyItemBehavior)this.behavior).getItemCapFromTile(this.targetPos, (Direction)((StarbyItemBehavior)this.behavior).TO_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return true;
        }
        ItemStack oldStack = new ItemStack((ItemLike)this.starbuncle.getHeldStack().getItem(), this.starbuncle.getHeldStack().getCount());
        ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.starbuncle.getHeldStack(), (boolean)false);
        if (left.equals(oldStack)) {
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("no_room", this.targetPos.toString()));
            return true;
        }
        try {
            OpenChestEvent event = new OpenChestEvent((ServerLevel)this.starbuncle.level(), this.targetPos, 20);
            event.open();
            EventQueue.getServerInstance().addEvent((ITimedEvent)event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.starbuncle.setHeldStack(left);
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("stored_item", "successful at " + this.targetPos.toString() + "set stack to " + left.getCount() + "x " + left.getHoverName().getString()));
        return true;
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyItemBehavior)this.behavior).sortPrefForStack(pos, this.starbuncle.getHeldStack()) != ItemScroll.SortPref.INVALID;
    }
}

