/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import alexthw.starbunclemania.client.JarRenderer;
import alexthw.starbunclemania.common.DualFluidTank;
import alexthw.starbunclemania.common.block.wixie_stations.MixerWixieCauldronTile;
import com.alexthw.sauce.registry.ModRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class WixieMixerRenderer
implements BlockEntityRenderer<MixerWixieCauldronTile> {
    private static final Vector3f LIQUID_DIMENSIONS = new Vector3f(0.75f, 0.59375f, 0.0625f);
    private static final Vector3f SOURCE_DIMENSIONS = new Vector3f(0.6f, 0.2f, 0.7f);

    public WixieMixerRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull MixerWixieCauldronTile blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!blockEntity.converted) {
            return;
        }
        DualFluidTank tank = blockEntity.tank;
        for (int i = 0; i < tank.getTanks(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, -0.05 + 0.6 * (double)i);
            poseStack.scale(1.0f, 1.0f, 0.5f);
            FluidStack fluid = tank.getFluidInTank(i);
            if (!fluid.isEmpty()) {
                JarRenderer.renderFluid((float)fluid.getAmount() / (float)tank.getTankCapacity(i), IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid), fluid.getFluid().getFluidType().getLightLevel(), IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(), poseStack, bufferSource, packedLight, true, LIQUID_DIMENSIONS);
            }
            poseStack.popPose();
        }
        if (blockEntity.hasSource) {
            Fluid fluid = (Fluid)ModRegistry.SOURCE_FLUID.get();
            JarRenderer.renderFluid(1.0f, IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(), fluid.getFluidType().getLightLevel(), IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(), poseStack, bufferSource, packedLight, true, SOURCE_DIMENSIONS);
        }
    }
}

