/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.item;

import alexthw.starbunclemania.common.data.FluidScrollData;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.starbuncle.StarHelper;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidScroll
extends ModItem
implements IScribeable {
    public FluidScroll(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (pUsedHand == InteractionHand.MAIN_HAND && !pLevel.isClientSide) {
            ItemStack thisStack = pPlayer.getItemInHand(pUsedHand);
            ItemStack otherStack = pPlayer.getItemInHand(InteractionHand.OFF_HAND);
            if (!otherStack.isEmpty()) {
                this.onScribe(pLevel, pPlayer.blockPosition(), pPlayer, InteractionHand.OFF_HAND, thisStack);
                return InteractionResultHolder.success((Object)thisStack);
            }
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public static boolean checkForFilters(@Nullable BlockPos pos, ItemStack scroll, FluidStack fluid, Level level) {
        FluidScroll filter;
        Item item;
        boolean scrollCheck;
        boolean bl = scrollCheck = scroll != null && (item = scroll.getItem()) instanceof FluidScroll && (filter = (FluidScroll)item).isDenied(scroll, fluid);
        if (pos != null) {
            return StarHelper.checkItemFramesForFluid(pos, level, scrollCheck, fluid);
        }
        return scrollCheck;
    }

    public boolean isDenied(ItemStack fluidScroll, FluidStack fluidInTank) {
        FluidScrollData filter = (FluidScrollData)fluidScroll.get(ModRegistry.FLUID_SCROLL);
        if (filter == null) {
            return false;
        }
        return !filter.containsStack(fluidInTank);
    }

    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        ItemStack container = player.getItemInHand(handIn);
        FluidScrollData scrollData = (FluidScrollData)thisStack.get(ModRegistry.FLUID_SCROLL);
        IFluidHandlerItem fluidCap = (IFluidHandlerItem)container.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidCap != null && scrollData != null) {
            return scrollData.mutable().writeWithFeedback(player, fluidCap.getFluidInTank(0));
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        FluidScrollData fluidScrollData = (FluidScrollData)stack.get(ModRegistry.FLUID_SCROLL);
        if (fluidScrollData == null) {
            return;
        }
        for (FluidStack s : fluidScrollData.mutable().getItems()) {
            tooltip2.add(s.getHoverName());
        }
    }
}

