/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.wixie_stations;

import alexthw.starbunclemania.common.block.wixie_stations.FarmerPotWixieCauldronTile;
import com.hollingsworth.arsnouveau.common.block.WixieCauldron;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class FarmerPotWixieCauldron
extends WixieCauldron {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public WixieCauldronTile newBlockEntity(BlockPos pos, BlockState state) {
        return new FarmerPotWixieCauldronTile(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((CookingPotSupport)state.getValue((Property)CookingPotBlock.SUPPORT)).equals((Object)CookingPotSupport.TRAY) ? SHAPE_WITH_TRAY : SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        WixieCauldronTile cookingPotEntity;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof WixieCauldronTile && !(cookingPotEntity = (WixieCauldronTile)tileEntity).isCraftingDone() && cookingPotEntity.hasSource) {
            SoundEvent boilSound = (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL.get();
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (random.nextInt(10) == 0) {
                level.playLocalSound(x, y, z, boilSound, SoundSource.BLOCKS, 0.25f, random.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        pState.setValue((Property)CookingPotBlock.FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)CookingPotBlock.FACING)));
        return pState;
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)CookingPotBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)CookingPotBlock.FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CookingPotBlock.FACING, CookingPotBlock.SUPPORT});
    }
}

