/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania;

import alexthw.starbunclemania.glyph.PickupFluidEffect;
import alexthw.starbunclemania.glyph.PlaceFluidEffect;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.starbuncle.energy.StarbyEnergyBehavior;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import alexthw.starbunclemania.starbuncle.heal.StarbyHealerBehavior;
import alexthw.starbunclemania.starbuncle.item.AdvancedItemTransportBehavior;
import alexthw.starbunclemania.starbuncle.item.RRobinItemTransport;
import alexthw.starbunclemania.starbuncle.miner.StarbyMinerBehavior;
import alexthw.starbunclemania.starbuncle.placer.StarbyPlacerBehavior;
import alexthw.starbunclemania.starbuncle.sword.StarbyFighterBehavior;
import alexthw.starbunclemania.starbuncle.trash.StarbyVoidBehavior;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.registry.BehaviorRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.JarBehaviorRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ArsNouveauRegistry {
    public static final List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();

    public static void register() {
        ArsNouveauRegistry.register((AbstractSpellPart)PlaceFluidEffect.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)PickupFluidEffect.INSTANCE);
        BehaviorRegistry.register((ResourceLocation)AdvancedItemTransportBehavior.TRANSPORT_ID, (entity, tag) -> new AdvancedItemTransportBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)RRobinItemTransport.TRANSPORT_ID, (entity, tag) -> new RRobinItemTransport((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyEnergyBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyEnergyBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyFluidBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyFluidBehavior((Starbuncle)entity, tag));
        if (ModList.get().isLoaded("mekanism")) {
            BehaviorRegistry.register((ResourceLocation)StarbyGasBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyGasBehavior((Starbuncle)entity, tag));
        }
        BehaviorRegistry.register((ResourceLocation)StarbyVoidBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyVoidBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyFighterBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyFighterBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyHealerBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyHealerBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyMinerBehavior.MINER_ID, (entity, tag) -> new StarbyMinerBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyPlacerBehavior.MINER_ID, (entity, tag) -> new StarbyPlacerBehavior((Starbuncle)entity, tag));
    }

    public static void postInit() {
        LightManager.register((EntityType)((EntityType)ModRegistry.STARBY_MOUNT.get()), p -> {
            if (p.level().getBrightness(LightLayer.BLOCK, p.blockPosition()) < 6) {
                return 10;
            }
            return 0;
        });
        ArsNouveauRegistry.registerJarBehaviors();
    }

    public static void register(AbstractSpellPart spellPart) {
        GlyphRegistry.registerSpell((AbstractSpellPart)spellPart);
        registeredSpells.add(spellPart);
    }

    public static void registerJarBehaviors() {
        JarBehaviorRegistry.register((EntityType)EntityType.COW, (JarBehavior)new JarBehavior<Cow>(){

            public void tick(MobJarTile tile) {
                FluidStack fluid;
                IFluidHandler cap;
                super.tick(tile);
                Level level = tile.getLevel();
                if (level instanceof ServerLevel && level.getGameTime() % 20L == 0L && (cap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), (Object)null)) != null && ((fluid = cap.getFluidInTank(0)).isEmpty() || fluid.getFluid().isSame((Fluid)NeoForgeMod.MILK.get()) && fluid.getAmount() < cap.getTankCapacity(0))) {
                    cap.fill(new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        });
        JarBehaviorRegistry.register((EntityType)EntityType.MOOSHROOM, (JarBehavior)new JarBehavior<MushroomCow>(){

            public void tick(MobJarTile tile) {
                FluidStack fluid;
                IFluidHandler cap;
                super.tick(tile);
                Level level = tile.getLevel();
                if (level instanceof ServerLevel && level.getGameTime() % 20L == 0L && (cap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), (Object)null)) != null && ((fluid = cap.getFluidInTank(0)).isEmpty() || fluid.getFluid().isSame((Fluid)NeoForgeMod.MILK.get()) && fluid.getAmount() < cap.getTankCapacity(0))) {
                    cap.fill(new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        });
    }
}

