/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.lwjgl.opengl.GL20;

public class ImageButtonWidget
extends AbstractWidget {
    float durationHovered = 0.0f;
    private final ResourceLocation imageLocation;
    private final Consumer<ImageButtonWidget> onPress;
    private static final int ICON_SIZE = 32;
    private static final int ICON_TEXT_SPACING = 5;

    public ImageButtonWidget(int x, int y, int width, int height, Component message, ResourceLocation imageLocation, Consumer<ImageButtonWidget> clickEvent) {
        super(x, y, width, height, message);
        this.imageLocation = imageLocation;
        this.onPress = clickEvent;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean verticalLayout;
        this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        this.durationHovered = this.isHovered || this.isFocused() ? Math.min(this.durationHovered + delta / 2.0f, 1.0f) : Math.max(this.durationHovered - delta / 4.0f, 0.0f);
        float alphaScale = Mth.clampedLerp((float)0.9f, (float)0.5f, (float)this.durationHovered);
        int a = (int)(255.0f * alphaScale);
        int greyColor = a << 24;
        context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, greyColor);
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.font);
        int fontHeight = 9;
        int textWidth = client.font.width((FormattedText)this.getMessage());
        int totalHorizontalWidth = 37 + textWidth;
        boolean preferHorizontal = totalHorizontalWidth <= this.width && (float)this.width >= 2.0f * (float)this.height;
        boolean bl = verticalLayout = !preferHorizontal;
        if (verticalLayout) {
            int totalHeight = 37 + fontHeight;
            int iconY = this.getY() + (this.height - totalHeight) / 2;
            List wrappedText = client.font.split((FormattedText)this.getMessage(), this.width - 20);
            int wrappedTextHeight = wrappedText.size() * fontHeight;
            int textY = iconY + 32 + 5;
            if (wrappedText.size() > 1) {
                int overallStartY;
                int textStartY = textY + (fontHeight - wrappedTextHeight) / 2;
                int currentTextY = textY;
                int combinedTotalHeight = 37 + wrappedTextHeight;
                iconY = overallStartY = this.getY() + (this.height - combinedTotalHeight) / 2;
                int iconX = this.getX() + (this.width - 32) / 2;
                currentTextY = textY = overallStartY + 32 + 5;
                this.renderIcon(context, iconX, iconY);
                for (FormattedCharSequence line : wrappedText) {
                    context.drawCenteredString(client.font, line, this.getX() + this.width / 2, currentTextY, 0xFFFFFF);
                    currentTextY += fontHeight;
                }
            } else {
                int overallStartY;
                int combinedTotalHeight = 37 + fontHeight;
                iconY = overallStartY = this.getY() + (this.height - combinedTotalHeight) / 2;
                int iconX = this.getX() + (this.width - 32) / 2;
                textY = overallStartY + 32 + 5;
                this.renderIcon(context, iconX, iconY);
                context.drawCenteredString(client.font, this.getMessage(), this.getX() + this.width / 2, textY, 0xFFFFFF);
            }
        } else {
            int startX;
            int totalWidth = 37 + textWidth;
            int iconX = startX = this.getX() + (this.width - totalWidth) / 2;
            int iconY = this.getY() + (this.height - 32) / 2;
            this.renderIcon(context, iconX, iconY);
            int textX = iconX + 32 + 5;
            int textY = this.getY() + (this.height - fontHeight) / 2;
            List wrappedText = client.font.split((FormattedText)this.getMessage(), this.width - 32 - 5 - 10);
            if (wrappedText.size() > 1) {
                int textStartY;
                int wrappedTextHeight = wrappedText.size() * fontHeight;
                int currentTextY = textStartY = this.getY() + (this.height - wrappedTextHeight) / 2;
                for (FormattedCharSequence line : wrappedText) {
                    context.drawString(client.font, line, textX, currentTextY, 0xFFFFFF);
                    currentTextY += fontHeight;
                }
            } else {
                context.drawString(client.font, this.getMessage(), textX, textY, 0xFFFFFF);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.renderOutline(this.getX(), this.getY(), this.width, this.height, 0xFFFFFFF);
    }

    private static void renderTexture(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int textureWidth, int textureHeight) {
        drawContext.blit(texture, x, y, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderIcon(GuiGraphics context, int x, int y) {
        int minFilterScalingTypePrev = GL20.glGetTexParameteri((int)3553, (int)10241);
        int magFilterScalingTypePrev = GL20.glGetTexParameteri((int)3553, (int)10240);
        try {
            GL20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL20.glTexParameteri((int)3553, (int)10240, (int)9729);
            context.pose().pushPose();
            context.pose().scale(0.0625f, 0.0625f, 1.0f);
            context.blit(this.imageLocation, (int)((float)x / 0.0625f), (int)((float)y / 0.0625f), 0.0f, 0.0f, 512, 512, 512, 512);
            context.pose().popPose();
        }
        catch (Exception exception) {
        }
        finally {
            GL20.glTexParameteri((int)3553, (int)10241, (int)minFilterScalingTypePrev);
            GL20.glTexParameteri((int)3553, (int)10240, (int)magFilterScalingTypePrev);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        builder.add(NarratedElementType.HINT, this.getMessage());
    }
}

