/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.sound;

import dev.imb11.sounds.api.config.DynamicConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.util.MixinStatics;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class InventoryDynamicConfiguredSound
extends DynamicConfiguredSound<ItemStack, ItemStackSoundContext> {
    private static final HashMap<String, Long> itemTypeCooldownMap = new HashMap();

    public InventoryDynamicConfiguredSound(String id, ResourceLocation soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    public InventoryDynamicConfiguredSound(String id, SoundEvent soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    public InventoryDynamicConfiguredSound(String id, Holder.Reference<SoundEvent> soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume, enableDynamicSounds);
    }

    @Override
    public void playDynamicSound(ItemStack context, ItemStackSoundContext contextHandler) {
        if (context.isEmpty() && SoundsConfig.get(UISoundsConfig.class).ignoreEmptyInventorySlots || MixinStatics.temporarilyDisableInventorySounds) {
            return;
        }
        if (!context.isEmpty()) {
            long lastPlayedTime;
            String itemId = context.getItem().getDescriptionId();
            float cooldownDuration = SoundsConfig.get(UISoundsConfig.class).itemSoundCooldown * 1000.0f;
            long currentTime = System.currentTimeMillis();
            if (itemTypeCooldownMap.containsKey(itemId) && (float)(currentTime - (lastPlayedTime = itemTypeCooldownMap.get(itemId).longValue())) < cooldownDuration) {
                return;
            }
            itemTypeCooldownMap.put(itemId, currentTime);
        }
        super.playDynamicSound(context, contextHandler);
    }
}

