/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.loaders.neoforge;

import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.dynamic.SoundsReloadListener;
import dev.imb11.sounds.gui.SoundsConfigScreen;
import dev.imb11.sounds.sound.CustomSounds;
import dev.imb11.sounds.sound.events.PotionEventHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="sounds", dist={Dist.CLIENT})
public class SoundsNeoForge {
    private static final PotionEventHelper potionEventHelper = new PotionEventHelper();

    public SoundsNeoForge(IEventBus bus) {
        SoundsClient.init();
        CustomSounds.REGISTRY.register(bus);
        ModLoadingContext.get().getActiveContainer().registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(client, parent) -> new SoundsConfigScreen(parent)));
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        private static void clientTickEvent(ClientTickEvent.Pre event) {
            potionEventHelper.listenForEffectChanges(Minecraft.getInstance().level);
        }

        @SubscribeEvent
        private static void registerResourceReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new SoundsReloadListener());
        }
    }
}

