/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.config;

import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class EventSoundsConfig
extends ConfigGroup<EventSoundsConfig>
implements YetAnotherConfigLib.ConfigBackedBuilder<EventSoundsConfig> {
    @SerialEntry
    public boolean ignoreSilencedStatusEffects = true;
    @SerialEntry
    public ConfiguredSound positiveStatusEffectGainSoundEffect = new ConfiguredSound("positiveStatusEffectGain", (Holder<SoundEvent>)SoundEvents.TRIDENT_THUNDER, true, 2.0f, 0.1f);
    @SerialEntry
    public ConfiguredSound negativeStatusEffectGainSoundEffect = new ConfiguredSound("negativeStatusEffectGain", SoundEvents.ILLUSIONER_MIRROR_MOVE, true, 0.3f, 0.2f);
    @SerialEntry
    public ConfiguredSound positiveStatusEffectLoseSoundEffect = new ConfiguredSound("positiveStatusEffectLose", (Holder<SoundEvent>)SoundEvents.TRIDENT_RIPTIDE_1, true, 0.5f, 0.1f);
    @SerialEntry
    public ConfiguredSound negativeStatusEffectLoseSoundEffect = new ConfiguredSound("negativeStatusEffectLose", (Holder<SoundEvent>)SoundEvents.TRIDENT_RIPTIDE_1, true, 0.5f, 0.1f);

    public EventSoundsConfig() {
        super(EventSoundsConfig.class);
    }

    @Override
    public YetAnotherConfigLib getYACL() {
        return YetAnotherConfigLib.create(this.getHandler(), (YetAnotherConfigLib.ConfigBackedBuilder)this);
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"sounds", (String)"textures/gui/event_sounds.png");
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"sounds.config.events");
    }

    @Override
    public String getID() {
        return "event";
    }

    public YetAnotherConfigLib.Builder build(EventSoundsConfig defaults, EventSoundsConfig config, YetAnotherConfigLib.Builder builder) {
        builder.title(Component.nullToEmpty((String)"Event Sounds"));
        builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"sounds.config.events.statusEffects")).option(SoundsConfig.HELPER.get("ignoreSilencedStatusEffects", config.ignoreSilencedStatusEffects, () -> config.ignoreSilencedStatusEffects, v -> {
            config.ignoreSilencedStatusEffects = v;
        })).group(config.positiveStatusEffectGainSoundEffect.getOptionGroup(defaults.positiveStatusEffectGainSoundEffect)).group(config.positiveStatusEffectLoseSoundEffect.getOptionGroup(defaults.positiveStatusEffectLoseSoundEffect)).group(config.negativeStatusEffectGainSoundEffect.getOptionGroup(defaults.negativeStatusEffectGainSoundEffect)).group(config.negativeStatusEffectLoseSoundEffect.getOptionGroup(defaults.negativeStatusEffectLoseSoundEffect)).build());
        return builder;
    }
}

