/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockEntity
extends StorageBlockEntity {
    public static final String PACKED_TAG = "packed";
    @Nullable
    private WoodType woodType = null;
    private boolean packed = false;

    protected WoodStorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        if (this.woodType != null) {
            tag.putString("woodType", this.woodType.name());
        }
        tag.putBoolean(PACKED_TAG, this.packed);
    }

    public CompoundTag getStorageContentsTag() {
        CompoundTag contents = this.saveWithoutMetadata((HolderLookup.Provider)this.level.registryAccess());
        contents.putBoolean(PACKED_TAG, false);
        return contents;
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadSynchronizedData(tag, registries);
        this.woodType = NBTHelper.getString((CompoundTag)tag, (String)"woodType").flatMap(woodTypeName -> WoodType.values().filter(wt -> wt.name().equals(woodTypeName)).findFirst()).orElse(this.getStorageWrapper().hasMainColor() && this.getStorageWrapper().hasAccentColor() ? null : WoodType.ACACIA);
        this.packed = tag.getBoolean(PACKED_TAG);
    }

    public Optional<WoodType> getWoodType() {
        return Optional.ofNullable(this.woodType);
    }

    public void setWoodType(WoodType woodType) {
        this.woodType = woodType;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            this.setChanged();
        }
    }

    @Override
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.makeWoodStorageDescriptionId(this.getWoodType().orElse(null));
    }

    private Component makeWoodStorageDescriptionId(@Nullable WoodType wt) {
        String id = Util.makeDescriptionId((String)"block", (ResourceLocation)Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock())));
        return WoodStorageBlockItem.getDisplayName(id, wt);
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
        if (packed) {
            RenderInfo renderInfo = this.getStorageWrapper().getRenderInfo();
            renderInfo.removeAllUpgradeRenderData();
        }
    }

    @Override
    public boolean shouldDropContents() {
        return !this.isPacked();
    }

    @Override
    @Nullable
    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        if (this.isPacked()) {
            return null;
        }
        return super.getExternalItemHandler(side);
    }

    @Override
    public boolean canConnectStorages() {
        return !this.packed && super.canConnectStorages();
    }

    @Override
    public boolean canBeConnected() {
        return !this.packed && super.canBeConnected();
    }

    public boolean canBeLinked() {
        return !this.packed;
    }

    @Override
    protected boolean canRefreshUpgrades() {
        return super.canRefreshUpgrades() && !this.packed;
    }
}

