/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.UUIDDeduplicator;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsPayload;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public class BackpackContainer
extends StorageContainerMenuBase<IBackpackWrapper>
implements ISyncedContainer {
    private final BackpackContext backpackContext;

    public BackpackContainer(int windowId, Player player, BackpackContext backpackContext) {
        super(ModItems.BACKPACK_CONTAINER_TYPE.get(), windowId, player, (IStorageWrapper)backpackContext.getBackpackWrapper(player), backpackContext.getParentBackpackWrapper(player).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE), backpackContext.getBackpackSlotIndex(), backpackContext.shouldLockBackpackSlot(player));
        this.backpackContext = backpackContext;
        ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(backpackUuid -> {
            ItemStack backpack = ((IBackpackWrapper)this.storageWrapper).getBackpack();
            BackpackAccessLogger.logPlayerAccess(player, backpack.getItem(), backpackUuid, backpack.getHoverName().getString(), ((IBackpackWrapper)this.storageWrapper).getMainColor(), ((IBackpackWrapper)this.storageWrapper).getAccentColor(), ((IBackpackWrapper)this.storageWrapper).getColumnsTaken());
            if (!player.level().isClientSide()) {
                UUIDDeduplicator.checkForDuplicateBackpacksAndRemoveTheirUUID(player, backpackUuid, ((IBackpackWrapper)this.storageWrapper).getBackpack());
            }
        });
        if (backpackContext.shouldSaveAfterOpen()) {
            backpackContext.saveBackpackStack();
        }
    }

    public Optional<BlockPos> getBlockPosition() {
        BackpackContext.ContextType type = this.backpackContext.getType();
        if (type == BackpackContext.ContextType.BLOCK_BACKPACK || type == BackpackContext.ContextType.BLOCK_SUB_BACKPACK) {
            return Optional.of(this.backpackContext.getBackpackPosition(this.player));
        }
        return Optional.empty();
    }

    public Optional<Entity> getEntity() {
        return this.backpackContext.getOwnerPlayer(this.player);
    }

    protected void sendStorageSettingsToClient() {
        if (this.player.level().isClientSide) {
            return;
        }
        ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
            CompoundTag settingsContents = new CompoundTag();
            CompoundTag settingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt();
            if (!settingsNbt.isEmpty()) {
                settingsContents.put("settings", (Tag)settingsNbt);
                Player patt0$temp = this.player;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BackpackContentsPayload((UUID)uuid, settingsContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new BackpackUpgradeSlot(upgradeHandler, slotIndex);
    }

    public boolean stillValid(Player player) {
        return this.backpackContext.canInteractWith(player);
    }

    public static BackpackContainer fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new BackpackContainer(windowId, playerInventory.player, BackpackContext.fromBuffer(buffer, playerInventory.player.level()));
    }

    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putString("action", "openSettings"));
            return;
        }
        this.player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> new BackpackSettingsContainerMenu(w, pl, this.backpackContext), (Component)Component.translatable((String)SBPTranslationHelper.INSTANCE.translGui("settings.title")), false), this.backpackContext::toBuffer);
    }

    protected boolean storageItemHasChanged() {
        return this.backpackContext.getBackpackWrapper(this.player) != this.storageWrapper;
    }

    public boolean detectSettingsChangeAndReload() {
        return ((IBackpackWrapper)this.storageWrapper).getContentsUuid().map(uuid -> {
            BackpackStorage storage = BackpackStorage.get();
            if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                this.refreshInventorySlotsIfNeeded();
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected boolean shouldSlotItemBeDroppedFromStorage(Slot slot) {
        return slot.getItem().getItem() instanceof BackpackItem && !((IBackpackWrapper)this.storageWrapper).getInventoryHandler().isItemValid(0, slot.getItem());
    }

    public class BackpackUpgradeSlot
    extends StorageContainerMenuBase.StorageUpgradeSlot {
        public BackpackUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
            super((StorageContainerMenuBase)BackpackContainer.this, upgradeHandler, slotIndex);
        }

        protected void onUpgradeChanged() {
            super.onUpgradeChanged();
            BackpackContainer.this.backpackContext.onUpgradeChanged(BackpackContainer.this.player);
        }
    }
}

