/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackpackLayerRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public BackpackLayerRenderer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
        BackpackModelManager.initModels();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            PlayerInventoryProvider.get().getBackpackFromRendered((Player)player).ifPresent(backpackRenderInfo -> {
                poseStack.pushPose();
                ItemStack backpack = backpackRenderInfo.getBackpack();
                IBackpackModel model = BackpackModelManager.getBackpackModel(backpack.getItem());
                EquipmentSlot equipmentSlot = model.getRenderEquipmentSlot();
                boolean wearsArmor = (equipmentSlot != EquipmentSlot.CHEST || !backpackRenderInfo.isArmorSlot()) && !((ItemStack)player.getInventory().armor.get(equipmentSlot.getIndex())).isEmpty();
                BackpackLayerRenderer.renderBackpack(this.getParentModel(), (LivingEntity)player, poseStack, buffer, packedLight, backpack, wearsArmor, model);
                poseStack.popPose();
            });
        } else {
            poseStack.pushPose();
            ItemStack chestStack = entity.getItemBySlot(EquipmentSlot.CHEST);
            if (chestStack.getItem() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(this.getParentModel(), entity, poseStack, buffer, packedLight, chestStack, false, BackpackModelManager.getBackpackModel(chestStack.getItem()));
            }
            poseStack.popPose();
        }
    }

    public static <T extends LivingEntity, M extends EntityModel<T>> void renderBackpack(M parentModel, LivingEntity livingEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, ItemStack backpack, boolean wearsArmor, IBackpackModel model) {
        model.translateRotateAndScale(parentModel, livingEntity, matrixStack, wearsArmor);
        IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
        int clothColor = wrapper.getMainColor();
        int borderColor = wrapper.getAccentColor();
        model.render(parentModel, livingEntity, matrixStack, buffer, packedLight, clothColor, borderColor, backpack.getItem(), wrapper.getRenderInfo());
        BackpackLayerRenderer.renderUpgrades(livingEntity, wrapper.getRenderInfo());
        BackpackLayerRenderer.renderItemShown(matrixStack, buffer, packedLight, wrapper.getRenderInfo(), livingEntity.level());
    }

    private static void renderItemShown(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, RenderInfo renderInfo, @Nullable Level level) {
        renderInfo.getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.9, -0.25);
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f + (float)displayItem.getRotation()));
            Minecraft.getInstance().getItemRenderer().renderStatic(displayItem.getItem(), ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, level, 0);
            matrixStack.popPose();
        });
    }

    private static void renderUpgrades(LivingEntity livingEntity, RenderInfo renderInfo) {
        if (Minecraft.getInstance().isPaused() || livingEntity.level().random.nextInt(32) != 0) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> BackpackLayerRenderer.renderUpgrade(renderer, livingEntity, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(LivingEntity livingEntity, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        point.rotate((Quaternionfc)Axis.XP.rotationDegrees(livingEntity.isCrouching() ? 25.0f : 0.0f));
        point.add(0.0f, 0.8f, livingEntity.isCrouching() ? 0.9f : 0.7f);
        point.rotate((Quaternionfc)Axis.YN.rotationDegrees(livingEntity.yBodyRot - 180.0f));
        point.add((Vector3fc)livingEntity.position().toVector3f());
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, LivingEntity livingEntity, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(livingEntity.level(), livingEntity.level().random, vector3d -> BackpackLayerRenderer.getBackpackMiddleFacePoint(livingEntity, vector3d), renderData));
    }
}

