/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.item;

import com.talhanation.smallships.world.entity.cannon.GroundCannonEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class CannonItem
extends Item {
    public CannonItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockPos blockPos;
        if (useOnContext.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Player player = useOnContext.getPlayer();
        Level level = useOnContext.getLevel();
        BlockState blockState = level.getBlockState(blockPos = useOnContext.getClickedPos());
        if (!blockState.isSolid() && !blockState.is(BlockTags.RAILS) || useOnContext.getClickedFace() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = useOnContext.getItemInHand();
        Vec3 pos = new Vec3((double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5);
        if (blockState.is(BlockTags.RAILS)) {
            RailShape railShape = blockState.getBlock() instanceof BaseRailBlock ? (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            double d = 0.0;
            if (railShape.isAscending()) {
                d = 0.5;
            }
            pos = new Vec3(pos.x, pos.y - 1.0 + 0.0625 + d, pos.z);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GroundCannonEntity cannon = new GroundCannonEntity(level, pos);
            cannon.setYRot(player.getYRot());
            CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
            if (data != null) {
                data.loadInto((Entity)cannon);
            }
            serverLevel.addFreshEntity((Entity)cannon);
            serverLevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockPos, GameEvent.Context.of((Entity)useOnContext.getPlayer(), (BlockState)serverLevel.getBlockState(blockPos.below())));
        }
        itemStack.consume(1, (LivingEntity)player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

