/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.mixin.container.SimpleContainerAccessor;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.inventory.ContainerUtility;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerShip
extends Ship
implements HasCustomInventoryScreen,
ContainerEntity {
    public static final EntityDataAccessor<Integer> CONTAINER_SIZE = SynchedEntityData.defineId(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Byte> ROWS = SynchedEntityData.defineId(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Byte> PAGES = SynchedEntityData.defineId(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Byte> PAGE_INDEX = SynchedEntityData.defineId(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Byte> CONTAINER_FILL_STATE = SynchedEntityData.defineId(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final int originalContainerSize;
    NonNullList<ItemStack> itemStacks;
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;
    public final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ContainerShip.this.getData(ROWS).byteValue();
                case 1 -> ContainerShip.this.getData(PAGES).byteValue();
                case 2 -> ContainerShip.this.getData(PAGE_INDEX).byteValue();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ContainerShip.this.setData(ROWS, (byte)value);
                    break;
                }
                case 1: {
                    ContainerShip.this.setData(PAGES, (byte)value);
                    break;
                }
                case 2: {
                    ContainerShip.this.setData(PAGE_INDEX, (byte)value);
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public ContainerShip(EntityType<? extends Boat> entityType, Level level, int containerSize) {
        super(entityType, level);
        this.originalContainerSize = containerSize;
        this.updatePaging(this.originalContainerSize);
        this.setData(CONTAINER_SIZE, this.originalContainerSize);
        this.itemStacks = NonNullList.withSize((int)this.originalContainerSize, (Object)ItemStack.EMPTY);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CONTAINER_SIZE, (Object)this.originalContainerSize);
        builder.define(ROWS, (Object)6);
        builder.define(PAGES, (Object)1);
        builder.define(PAGE_INDEX, (Object)0);
        builder.define(CONTAINER_FILL_STATE, (Object)0);
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readContainerSizeSaveData(tag);
        this.readChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        this.setContainerFillState(tag.getByte("ContainerFillState"));
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addContainerSizeSaveData(tag);
        this.addChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        tag.putByte("ContainerFillState", this.getContainerFillState());
    }

    @Override
    public void destroy(@NotNull DamageSource damageSource) {
        super.destroy(damageSource);
        this.chestVehicleDestroyed(damageSource, this.level(), (Entity)this);
    }

    public void remove(@NotNull Entity.RemovalReason removalReason) {
        if (!this.getCommandSenderWorld().isClientSide() && removalReason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(removalReason);
    }

    @Override
    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!this.isLocked()) {
            return this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive() ? super.interact(player, interactionHand) : this.interactWithContainerVehicle(player);
        }
        return InteractionResult.PASS;
    }

    public void openCustomInventoryScreen(@NotNull Player player) {
        ContainerUtility.openShipMenu(player, this);
        if (!player.level().isClientSide()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.lootTable = lootTable;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void clearItemStacks() {
        this.itemStacks.clear();
    }

    public int getContainerSize() {
        return this.getData(CONTAINER_SIZE);
    }

    @NotNull
    public ItemStack getItem(int i) {
        return this.getChestVehicleItem(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        return this.removeChestVehicleItem(i, j);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return this.removeChestVehicleItemNoUpdate(i);
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        this.setChestVehicleItem(i, itemStack);
        this.updateContainerFillState();
    }

    @NotNull
    public SlotAccess getSlot(int n) {
        return this.getChestVehicleSlot(n);
    }

    public void setChanged() {
        this.updateContainerFillState();
    }

    public boolean stillValid(@NotNull Player player) {
        return this.isChestVehicleStillValid(player);
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory inventory, @NotNull Player player) {
        if (this.lootTable == null || !player.isSpectator()) {
            this.unpackChestVehicleLootTable(inventory.player);
            this.openCustomInventoryScreen(player);
        }
        return null;
    }

    public void readChestVehicleSaveData(@NotNull CompoundTag tag, HolderLookup.Provider levelRegistry) {
        this.clearItemStacks();
        if (tag.contains("LootTable", 8)) {
            this.setLootTable((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("LootTable"))));
            this.setLootTableSeed(tag.getLong("LootTableSeed"));
        } else {
            ContainerUtility.loadAllItems(tag, this.getItemStacks(), levelRegistry);
            this.resizeContainer(this.getContainerSize());
        }
    }

    public void addChestVehicleSaveData(@NotNull CompoundTag tag, HolderLookup.Provider levelRegistry) {
        if (this.getLootTable() != null) {
            tag.putString("LootTable", this.getLootTable().location().toString());
            if (this.getLootTableSeed() != 0L) {
                tag.putLong("LootTableSeed", this.getLootTableSeed());
            }
        } else {
            ContainerUtility.saveAllItems(tag, this.getItemStacks(), levelRegistry);
        }
    }

    public void readContainerSizeSaveData(CompoundTag tag) {
        int containerSize;
        if (!tag.contains("ContainerSize", 3)) {
            tag.putInt("ContainerSize", this.originalContainerSize);
        }
        if ((containerSize = tag.getInt("ContainerSize")) == 0) {
            containerSize = this.originalContainerSize;
        }
        this.updatePaging(containerSize);
        this.setData(CONTAINER_SIZE, containerSize);
        if (!this.level().isClientSide()) {
            this.level().players().stream().filter(player -> {
                ShipContainerMenu shipContainerMenu;
                AbstractContainerMenu patt0$temp = player.containerMenu;
                return patt0$temp instanceof ShipContainerMenu && (shipContainerMenu = (ShipContainerMenu)patt0$temp).getContainerShip().equals((Object)this);
            }).map(player -> (ServerPlayer)player).forEach(ServerPlayer::closeContainer);
        }
    }

    public void addContainerSizeSaveData(CompoundTag tag) {
        tag.putInt("ContainerSize", this.getData(CONTAINER_SIZE).intValue());
    }

    private void updatePaging(int containerSize) {
        int pages;
        int rowsPerPage;
        block4: {
            if (containerSize % 9 != 0) {
                throw new IllegalArgumentException("ShipContainerMenu can not be created with size " + containerSize + ". Make sure to use a container size that is divisible by 9.");
            }
            int allRows = containerSize / 9;
            rowsPerPage = 6;
            pages = 1;
            while (true) {
                if (pages * rowsPerPage >= allRows) {
                    if (pages * rowsPerPage != allRows) {
                        --rowsPerPage;
                        pages = 1;
                        continue;
                    }
                    break block4;
                }
                if (++pages > 127) break;
            }
            throw new IllegalArgumentException("ShipContainerMenu can not be created with size " + containerSize + ". Make sure to use a container size that requires less or equal to 128 pages. Current amount of required pages: " + pages);
        }
        this.setData(ROWS, (byte)rowsPerPage);
        this.setData(PAGES, (byte)pages);
        this.setData(PAGE_INDEX, (byte)0);
    }

    protected void updateContainerFillState() {
        int percent = (int)this.getInvFillStateInPercent();
        this.setContainerFillState((byte)percent);
    }

    public byte getInvFillState() {
        return (Byte)this.entityData.get(CONTAINER_FILL_STATE);
    }

    public double getInvFillStateInPercent() {
        int size = this.getItemStacks().size();
        double invFillStateInPercent = this.getItemStacks().stream().map(itemStack -> !itemStack.isEmpty() ? (double)itemStack.getCount() / (double)itemStack.getMaxStackSize() : 0.0).reduce(0.0, Double::sum) / (double)size;
        return invFillStateInPercent * 100.0;
    }

    public void resizeContainer(int containerSize) {
        this.itemStacks = ContainerShip.resizeItemStacks(this, containerSize);
    }

    private static NonNullList<ItemStack> resizeItemStacks(ContainerEntity containerEntity, int containerSize) {
        SimpleContainer newContainer;
        ItemStack[] oldItemStacks = (ItemStack[])containerEntity.getItemStacks().toArray(ItemStack[]::new);
        if (containerSize < oldItemStacks.length) {
            newContainer = new SimpleContainer(Arrays.copyOfRange(oldItemStacks, 0, containerSize));
            oldItemStacks = (ItemStack[])Arrays.stream(Arrays.copyOfRange(oldItemStacks, containerSize, oldItemStacks.length)).filter(stack -> !stack.isEmpty()).toArray(ItemStack[]::new);
            SimpleContainer leftoverContainer = new SimpleContainer(oldItemStacks.length);
            for (ItemStack oldItemStack : oldItemStacks) {
                leftoverContainer.addItem(newContainer.addItem(oldItemStack));
            }
            if (!leftoverContainer.isEmpty()) {
                Containers.dropContents((Level)containerEntity.level(), (Entity)((Entity)containerEntity), (Container)leftoverContainer);
            }
        } else {
            newContainer = new SimpleContainer(containerSize);
            for (int i = 0; i < containerSize; ++i) {
                if (i >= oldItemStacks.length) continue;
                newContainer.setItem(i, oldItemStacks[i]);
            }
        }
        return ((SimpleContainerAccessor)newContainer).getItems();
    }

    public byte getContainerFillState() {
        return (Byte)this.entityData.get(CONTAINER_FILL_STATE);
    }

    public void setContainerFillState(byte b) {
        this.entityData.set(CONTAINER_FILL_STATE, (Object)b);
    }

    public float getContainerModifier() {
        return ((Double)SmallShipsConfig.Common.shipGeneralContainerModifier.get()).floatValue() * (float)(this.getContainerFillState() - -128) / 255.0f;
    }
}

