/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.item.ModItems;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CogEntity
extends ContainerShip
implements Bannerable,
Sailable,
Cannonable,
Ability {
    public static final String ID = "cog";
    private static final int ORIGINAL_CONTAINER_SIZE = (Integer)SmallShipsConfig.Common.shipContainerCogContainerSize.get();

    public CogEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level, ORIGINAL_CONTAINER_SIZE);
    }

    private CogEntity(Level level, double d, double e, double f) {
        this(ModEntityTypes.COG, level);
        this.setPos(d, e, f);
        this.xo = d;
        this.yo = e;
        this.zo = f;
    }

    public static CogEntity summon(Level level, double d, double e, double f) {
        return new CogEntity(level, d, e, f);
    }

    @Override
    public CompoundTag createDefaultAttributes() {
        Attributes attributes = new Attributes();
        attributes.maxHealth = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxHealth.get()).floatValue();
        attributes.maxSpeed = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxSpeed.get()).floatValue();
        attributes.maxReverseSpeed = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxReverseSpeed.get()).floatValue();
        attributes.maxRotationSpeed = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxRotationSpeed.get()).floatValue();
        attributes.acceleration = ((Double)SmallShipsConfig.Common.shipAttributeCogAcceleration.get()).floatValue();
        attributes.rotationAcceleration = ((Double)SmallShipsConfig.Common.shipAttributeCogRotationAcceleration.get()).floatValue();
        CompoundTag tag = new CompoundTag();
        attributes.addSaveData(tag);
        return tag;
    }

    @Override
    public int getMaxPassengers() {
        return 5;
    }

    @Override
    @NotNull
    public Item getDropItem() {
        if (!((Boolean)SmallShipsConfig.Common.shipGeneralDoItemDrop.get()).booleanValue()) {
            return ItemStack.EMPTY.getItem();
        }
        return ModItems.COG_ITEMS.get(this.getVariant());
    }

    @Override
    public Ship.BiomeModifierType getBiomeModifierType() {
        return (Ship.BiomeModifierType)((Object)SmallShipsConfig.Common.shipModifierCogBiome.get());
    }

    @NotNull
    public Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        float v = 0.0f;
        float h = 0.0f;
        if (!this.getPassengers().isEmpty()) {
            int i = this.getPassengers().indexOf(entity);
            switch (i) {
                case 0: {
                    v += -2.25f;
                    h = 0.0f;
                    break;
                }
                case 1: {
                    v += -0.9f;
                    h = 0.9f;
                    break;
                }
                case 2: {
                    v += -0.9f;
                    h = -0.9f;
                    break;
                }
                case 3: {
                    v += 0.65f;
                    h = -0.75f;
                    break;
                }
                case 4: {
                    v += 0.65f;
                    h = 0.75f;
                    break;
                }
                default: {
                    v += 1.5f;
                    h = 0.0f;
                }
            }
        }
        return new Vec3((double)v, (double)dimensions.height() - 0.1, (double)h).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
    }

    @Override
    public Cannonable.CannonPosition getCannonPosition(int index) {
        ArrayList<Cannonable.CannonPosition> positionList = new ArrayList<Cannonable.CannonPosition>();
        Cannonable.CannonPosition pos1 = new Cannonable.CannonPosition(1.4, 0.2, 0.6, true);
        Cannonable.CannonPosition pos2 = new Cannonable.CannonPosition(1.4, 0.2, 0.6, false);
        Cannonable.CannonPosition pos3 = new Cannonable.CannonPosition(-0.6, 0.2, 0.6, true);
        Cannonable.CannonPosition pos4 = new Cannonable.CannonPosition(-0.6, 0.2, 0.6, false);
        positionList.add(pos1);
        positionList.add(pos2);
        positionList.add(pos3);
        positionList.add(pos4);
        return (Cannonable.CannonPosition)positionList.get(index);
    }

    @Override
    public byte getMaxCannonPerSide() {
        return 2;
    }

    @Override
    public Bannerable.BannerPosition getBannerPosition() {
        return new Bannerable.BannerPosition(-180.0f, 90.0f, -4.0, 0.78, 0.05);
    }

    @Override
    public void waterSplash() {
        Vec3 vector3d = this.getViewVector(0.0f);
        float f0 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.8f;
        float f1 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.8f;
        float f0_1 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.6f;
        float f1_1 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.6f;
        float f2 = 2.5f - this.random.nextFloat() * 0.7f;
        float f2_ = -1.3f - this.random.nextFloat() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ + (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ - (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ + (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ - (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ + (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ - (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ + (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ - (double)f0_1, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
        }
    }
}

