/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.projectile;

import com.mojang.datafixers.util.Pair;
import com.talhanation.smallships.world.entity.projectile.CannonBallEntity;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShipCannon
extends Entity {
    private final RandomSource random;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private int time;
    private int coolDown;
    private final Ship ship;
    private final Level level;
    private double angle;
    private boolean isRightSided;
    private boolean isLeftSided;

    public ShipCannon(Ship ship, Cannonable.CannonPosition cannonPosition) {
        this(ship, cannonPosition.x, cannonPosition.y, cannonPosition.z, cannonPosition.isRightSided, !cannonPosition.isRightSided);
    }

    public ShipCannon(Ship ship, double offsetX, double offsetY, double offsetZ, boolean isRightSided, boolean isLeftSided) {
        super(EntityType.ARMOR_STAND, ship.level());
        this.ship = ship;
        this.level = ship.level();
        this.random = this.level.getRandom();
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.resetTimer();
        this.coolDown = 0;
        if (isRightSided) {
            this.setRightSided();
        }
        if (isLeftSided) {
            this.setLeftSided();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        this.updatePosition();
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return null;
    }

    public void trigger() {
        if (this.coolDown == 0) {
            if (this.time > 0) {
                --this.time;
            }
            if (this.time == 0) {
                this.shoot();
                this.resetTimer();
                this.setCoolDown();
            }
        }
    }

    public void trigger(Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
        if (this.coolDown == 0) {
            if (this.time > 0) {
                --this.time;
            }
            if (this.time == 0) {
                this.shoot(shootVec, yShootVec, driverEntity, speed, accuracy);
                this.resetTimer();
                this.setCoolDown();
            }
        }
    }

    public void updatePosition() {
        Vec3 forward = this.ship.getForward();
        float x0 = 0.0f;
        double f0 = Math.cos(this.ship.getYRot() * ((float)Math.PI / 180)) * (double)x0;
        double f1 = Math.sin(this.ship.getYRot() * ((float)Math.PI / 180)) * (double)x0;
        double f2 = this.getOffsetX();
        double d1 = this.ship.getX() - forward.x * f2 + f0;
        double d2 = this.ship.getY() - forward.y + this.getOffsetY();
        double d3 = this.ship.getZ() - forward.z * f2 + f1;
        this.moveTo(d1, d2, d3);
    }

    private void resetTimer() {
        this.time = 10 + this.random.nextInt(10);
    }

    private void setCoolDown() {
        this.coolDown = 50;
    }

    public void shoot() {
        LivingEntity driverEntity = this.ship.getControllingPassenger();
        if (driverEntity == null) {
            return;
        }
        Vec3 forward = this.ship.getForward().normalize();
        Vec3 shootVec = this.getShootVector(forward, driverEntity);
        double speed = 2.6f;
        double accuracy = 3.0;
        boolean playerView = driverEntity.getLookAngle().y >= 0.0;
        double yShootVec = playerView ? shootVec.y() + driverEntity.getLookAngle().y * (double)0.95f : shootVec.y() + (double)0.15f;
        this.shoot(shootVec, yShootVec, driverEntity, speed, accuracy);
    }

    public void shoot(Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
        if (shootVec != null) {
            CannonBallEntity cannonBallEntity = new CannonBallEntity(this.level, driverEntity, this.getX(), this.getY() + 1.0, this.getZ());
            cannonBallEntity.shoot(shootVec.x(), yShootVec, shootVec.z(), (float)speed, (float)accuracy);
            this.level.addFreshEntity((Entity)cannonBallEntity);
            this.ship.playSound(SoundEvents.TNT_PRIMED, 1.0f, 1.125f);
            this.playCannonShotSound();
            Ship ship = this.ship;
            if (ship instanceof Cannonable) {
                Cannonable cannonable = (Cannonable)((Object)ship);
                cannonable.consumeCannonBall();
            }
        }
    }

    public Vec3 getShootVector(Vec3 forward, LivingEntity driver) {
        Vec3 VecRight = forward.yRot(-1.57f).normalize();
        Vec3 VecLeft = forward.yRot(1.57f).normalize();
        Vec3 playerVec = driver.getLookAngle().normalize();
        if (playerVec.distanceTo(VecLeft) > playerVec.distanceTo(VecRight)) {
            return VecRight;
        }
        if (playerVec.distanceTo(VecLeft) < playerVec.distanceTo(VecRight)) {
            return VecLeft;
        }
        return null;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getOffsetZ() {
        return this.offsetZ;
    }

    public float getAngle() {
        return (float)this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setLeftSided() {
        this.isLeftSided = true;
        this.setAngle(0.0);
    }

    public void setRightSided() {
        this.isRightSided = true;
        this.setAngle(180.0);
    }

    public boolean isRightSided() {
        return this.isRightSided;
    }

    public boolean canShootDirection() {
        LivingEntity driver = this.ship.getControllingPassenger();
        if (driver == null) {
            return false;
        }
        Vec3 forward = this.ship.getForward().normalize();
        Vec3 shootVec = this.getShootVector(forward, driver);
        Vec3 VecRight = forward.yRot(-1.57f).normalize();
        Vec3 VecLeft = forward.yRot(1.57f).normalize();
        if (this.isRightSided && Objects.equals(shootVec, VecRight)) {
            return true;
        }
        return this.isLeftSided && Objects.equals(shootVec, VecLeft);
    }

    public CompoundTag getData() {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putDouble("x", this.getOffsetX());
        compoundtag.putDouble("y", this.getOffsetY());
        compoundtag.putDouble("z", this.getOffsetZ());
        compoundtag.putBoolean("isRightSided", this.isRightSided());
        return compoundtag;
    }

    private void playCannonShotSound() {
        BiConsumer<SoundEvent, Pair> play = (sound, modifier) -> {
            if (!this.ship.level().isClientSide()) {
                this.ship.playSound((SoundEvent)sound, ((Float)modifier.getFirst()).floatValue(), ((Float)modifier.getSecond()).floatValue());
            } else {
                this.ship.level().playLocalSound(this.ship.getX(), this.ship.getY() + 4.0, this.ship.getZ(), sound, this.ship.getSoundSource(), ((Float)modifier.getFirst()).floatValue(), ((Float)modifier.getSecond()).floatValue(), false);
            }
        };
        play.accept(ModSoundTypes.CANNON_SHOT, Pair.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(1.0f)));
    }
}

