/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.jukebox;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.przemyk.simpleplanes.client.MovingSound;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.network.JukeboxPacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;

public class JukeboxUpgrade
extends LargeUpgrade {
    private ItemStack record = ItemStack.EMPTY;

    public JukeboxUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.JUKEBOX.get(), planeEntity);
    }

    @Override
    public Tag serializeNBT() {
        return this.record.save((HolderLookup.Provider)this.planeEntity.registryAccess());
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.record = ItemStack.parseOptional((HolderLookup.Provider)this.planeEntity.registryAccess(), (CompoundTag)nbt);
    }

    @Override
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player;
        ItemStack itemStack;
        if (!this.planeEntity.level().isClientSide && !(itemStack = (player = event.getEntity()).getItemInHand(event.getHand())).is(this.record.getItem())) {
            ItemStack oldRecord = this.record;
            this.record = itemStack.copy();
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            if (!oldRecord.isEmpty()) {
                player.addItem(oldRecord);
            }
            player.awardStat(Stats.PLAY_RECORD);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this.planeEntity, (CustomPacketPayload)new JukeboxPacket(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()), this.planeEntity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.pushPose();
        EntityType entityType = this.planeEntity.getType();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.translate(0.0, -0.1, -1.28);
        } else {
            matrixStack.translate(0.0, 0.0, 0.1);
        }
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.translate(-0.4, -1.0, 0.3);
        matrixStack.scale(0.82f, 0.82f, 0.82f);
        BlockState state = Blocks.JUKEBOX.defaultBlockState();
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        matrixStack.popPose();
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
        this.planeEntity.spawnAtLocation(this.record);
        if (this.planeEntity.level().isClientSide) {
            MovingSound.remove(this.planeEntity);
        }
    }

    @Override
    public ItemStack getItemStack() {
        return Items.JUKEBOX.getDefaultInstance();
    }
}

