/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.furnace;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.client.ModBusClientEventHandler;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.container.slots.FuelSlot;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class FurnaceEngineUpgrade
extends EngineUpgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler();
    public int burnTime;
    public int burnTimeTotal;

    public FurnaceEngineUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.FURNACE_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        ItemStack itemStack;
        int itemBurnTime;
        if (this.burnTime > 0) {
            this.burnTime -= this.planeEntity.getFuelCost();
            this.updateClient();
        } else if (this.planeEntity.getThrottle() > 0 && (itemBurnTime = (itemStack = this.itemStackHandler.getStackInSlot(0)).getBurnTime(RecipeType.SMELTING)) > 0) {
            this.burnTimeTotal = itemBurnTime;
            this.burnTime = itemBurnTime;
            if (itemStack.hasCraftingRemainingItem()) {
                this.itemStackHandler.setStackInSlot(0, itemStack.getCraftingRemainingItem());
            } else {
                this.itemStackHandler.extractItem(0, 1, false);
            }
            this.updateClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.burnTime > 0;
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.put("item", (Tag)this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess()));
        compound.putInt("burnTime", this.burnTime);
        compound.putInt("burnTimeTotal", this.burnTimeTotal);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), compound.getCompound("item"));
        this.burnTime = compound.getInt("burnTime");
        this.burnTimeTotal = compound.getInt("burnTimeTotal");
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.itemStackHandler.getStackInSlot(0));
        buffer.writeVarInt(this.burnTime);
        buffer.writeVarInt(this.burnTimeTotal);
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        this.itemStackHandler.setStackInSlot(0, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
        this.burnTime = buffer.readVarInt();
        this.burnTimeTotal = buffer.readVarInt();
    }

    @Override
    public <T> T getCap(BaseCapability<T, ?> cap) {
        if (cap == Capabilities.ItemHandler.ENTITY) {
            return (T)this.itemStackHandler;
        }
        return super.getCap(cap);
    }

    @Override
    public void onRemoved() {
        this.planeEntity.spawnAtLocation(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public ItemStack getItemStack() {
        return SimplePlanesItems.FURNACE_ENGINE.get().getDefaultInstance();
    }

    @Override
    public void renderPowerHUD(GuiGraphics guiGraphics, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
        ItemStack fuelStack;
        int i = scaledWidth / 2;
        Minecraft mc = Minecraft.getInstance();
        if (side == HumanoidArm.LEFT) {
            guiGraphics.blit(ModBusClientEventHandler.HUD_TEXTURE, i - 91 - 29, scaledHeight - 40, 0, 44, 22, 40);
        } else {
            guiGraphics.blit(ModBusClientEventHandler.HUD_TEXTURE, i + 91, scaledHeight - 40, 0, 44, 22, 40);
        }
        if (this.burnTime > 0) {
            int burnTimeTotal2 = this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal;
            int burnLeftScaled = this.burnTime * 13 / burnTimeTotal2;
            if (side == HumanoidArm.LEFT) {
                guiGraphics.blit(ModBusClientEventHandler.HUD_TEXTURE, i - 91 - 29 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            } else {
                guiGraphics.blit(ModBusClientEventHandler.HUD_TEXTURE, i + 91 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            }
        }
        if (!(fuelStack = this.itemStackHandler.getStackInSlot(0)).isEmpty()) {
            int i2 = scaledHeight - 16 - 3;
            if (side == HumanoidArm.LEFT) {
                guiGraphics.renderItem(fuelStack, i - 91 - 26, i2);
                guiGraphics.renderItemDecorations(mc.font, fuelStack, i - 91 - 26, i2);
            } else {
                guiGraphics.renderItem(fuelStack, i + 91 + 3, i2);
                guiGraphics.renderItemDecorations(mc.font, fuelStack, i + 91 + 3, i2);
            }
        }
    }

    @Override
    public void addContainerData(Function<Slot, Slot> addSlot, Function<DataSlot, DataSlot> addDataSlot) {
        addSlot.apply((Slot)new FuelSlot((IItemHandler)this.itemStackHandler, 0, 152, 62));
    }

    @Override
    public void renderScreenBg(GuiGraphics guiGraphics, int x, int y, float partialTicks, PlaneInventoryScreen screen) {
        guiGraphics.blit(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 151, screen.getGuiTop() + 44, 208, 0, 18, 35);
        if (this.burnTime > 0) {
            int burnLeftScaled = this.burnTime * 13 / (this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal);
            guiGraphics.blit(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 152, screen.getGuiTop() + 57 - burnLeftScaled, 208, 47 - burnLeftScaled, 14, burnLeftScaled + 1);
        }
    }
}

