/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import com.google.common.collect.ImmutableSet;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import xyz.przemyk.simpleplanes.entities.CargoPlaneEntity;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.ParachuteEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class SimplePlanesEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"simpleplanes");
    public static final Supplier<EntityType<PlaneEntity>> PLANE = ENTITIES.register("plane", () -> SimplePlanesEntities.createEntityType(PlaneEntity::new, EntityDimensions.scalable((float)2.5f, (float)1.8f)));
    public static final Supplier<EntityType<LargePlaneEntity>> LARGE_PLANE = ENTITIES.register("large_plane", () -> SimplePlanesEntities.createEntityType(LargePlaneEntity::new, EntityDimensions.scalable((float)3.0f, (float)2.3f)));
    public static final Supplier<EntityType<CargoPlaneEntity>> CARGO_PLANE = ENTITIES.register("cargo_plane", () -> SimplePlanesEntities.createEntityType(CargoPlaneEntity::new, EntityDimensions.scalable((float)3.0f, (float)2.3f)));
    public static final Supplier<EntityType<HelicopterEntity>> HELICOPTER = ENTITIES.register("helicopter", () -> SimplePlanesEntities.createEntityType(HelicopterEntity::new, EntityDimensions.scalable((float)2.5f, (float)2.2f)));
    public static final Supplier<EntityType<ParachuteEntity>> PARACHUTE = ENTITIES.register("parachute", () -> SimplePlanesEntities.createEntityType(ParachuteEntity::new, EntityDimensions.scalable((float)1.0f, (float)1.0f)));

    public static void init(IEventBus bus) {
        ENTITIES.register(bus);
    }

    private static <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> factory, EntityDimensions size) {
        return new EntityType(factory, MobCategory.MISC, true, true, false, true, ImmutableSet.of(), size, 1.0f, 5, 3, FeatureFlags.VANILLA_SET);
    }
}

