/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public record SUpgradeRemovedPacket(ResourceLocation upgradeID, int planeEntityID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpgradeRemovedPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"upgrade_removed"));
    public static final StreamCodec<ByteBuf, SUpgradeRemovedPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SUpgradeRemovedPacket::upgradeID, (StreamCodec)ByteBufCodecs.VAR_INT, SUpgradeRemovedPacket::planeEntityID, SUpgradeRemovedPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientLevel clientWorld = Minecraft.getInstance().level;
            ((PlaneEntity)clientWorld.getEntity(this.planeEntityID)).removeUpgrade(this.upgradeID);
        });
    }
}

