/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import com.mojang.math.Axis;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.client.PlaneSound;
import xyz.przemyk.simpleplanes.container.ModifyUpgradesContainer;
import xyz.przemyk.simpleplanes.container.PlaneInventoryContainer;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.RotationPacket;
import xyz.przemyk.simpleplanes.network.SUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesComponents;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.armor.ArmorUpgrade;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterUpgrade;

public class PlaneEntity
extends Entity
implements IEntityWithComplexSpawn {
    public static final EntityDataAccessor<Integer> MAX_HEALTH = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> HEALTH = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> MAX_SPEED = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> MATERIAL = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Quaternionf> Q = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.QUATERNION);
    public static final EntityDataAccessor<Integer> THROTTLE = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Byte> PITCH_UP = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Byte> YAW_RIGHT = SynchedEntityData.defineId(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final int MAX_THROTTLE = 5;
    public Quaternionf Q_Client = new Quaternionf();
    public Quaternionf Q_Prev = new Quaternionf();
    private int onGroundTicks;
    public final HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    public EngineUpgrade engineUpgrade = null;
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private Block planksMaterial;
    private int damageTimeout;
    public int notMovingTime;
    public int goldenHeartsTimeout = 0;
    private final int networkUpdateInterval;
    public float propellerRotationOld;
    public float propellerRotationNew;
    public static final TagKey<DimensionType> BLACKLISTED_DIMENSIONS_TAG = TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"blacklisted_dimensions"));
    protected float pitchSpeed = 0.0f;
    protected float yawSpeed = 0.0f;
    protected float rollSpeed = 0.0f;
    public static final TagKey<Block> FIREPROOF_MATERIALS_TAG = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"fireproof_materials"));
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private static final TempMotionVars TEMP_MOTION_VARS = new TempMotionVars();

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn) {
        this(entityTypeIn, worldIn, Blocks.OAK_PLANKS);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn, Block material) {
        super(entityTypeIn, worldIn);
        this.networkUpdateInterval = entityTypeIn.updateInterval();
        this.setMaterial(material);
        this.setMaxSpeed(1.0f);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn, Block material, double x, double y, double z) {
        this(entityTypeIn, worldIn, material);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(MAX_HEALTH, (Object)10);
        pBuilder.define(HEALTH, (Object)10);
        pBuilder.define(Q, (Object)new Quaternionf());
        pBuilder.define(MAX_SPEED, (Object)Float.valueOf(0.25f));
        pBuilder.define(MATERIAL, (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.OAK_PLANKS).toString());
        pBuilder.define(TIME_SINCE_HIT, (Object)0);
        pBuilder.define(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        pBuilder.define(THROTTLE, (Object)0);
        pBuilder.define(PITCH_UP, (Object)0);
        pBuilder.define(YAW_RIGHT, (Object)0);
    }

    public float getMaxSpeed() {
        return ((Float)this.entityData.get(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float maxSpeed) {
        this.entityData.set(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public Quaternionf getQ() {
        return new Quaternionf((Quaternionfc)this.entityData.get(Q));
    }

    public void setQ(Quaternionf q) {
        this.entityData.set(Q, (Object)q);
    }

    public Quaternionf getQ_Client() {
        return new Quaternionf((Quaternionfc)this.Q_Client);
    }

    public void setQ_Client(Quaternionf q) {
        this.Q_Client = q;
    }

    public Quaternionf getQ_Prev() {
        return new Quaternionf((Quaternionfc)this.Q_Prev);
    }

    public void setQ_prev(Quaternionf q) {
        this.Q_Prev = q;
    }

    public Block getMaterial() {
        return this.planksMaterial;
    }

    public void setHealth(int health) {
        this.entityData.set(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.entityData.get(HEALTH);
    }

    public int getMaxHealth() {
        return (Integer)this.entityData.get(MAX_HEALTH);
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getItemStack();
    }

    public void setMaterial(String material) {
        this.entityData.set(MATERIAL, (Object)material);
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)material));
        this.planksMaterial = block == null ? Blocks.OAK_PLANKS : block;
    }

    public void setMaterial(Block material) {
        this.entityData.set(MATERIAL, (Object)BuiltInRegistries.BLOCK.getKey((Object)material).toString());
        this.planksMaterial = material;
    }

    public boolean isPowered() {
        return this.isAlive() && !this.level().dimensionTypeRegistration().is(BLACKLISTED_DIMENSIONS_TAG) && (this.isCreative() || this.engineUpgrade != null && this.engineUpgrade.isPowered());
    }

    protected boolean canAddPassenger(Entity passenger) {
        List passengers = this.getPassengers();
        if (!this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.SEATS.get()))) {
            return passengers.isEmpty();
        }
        return passengers.size() < 3;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && itemStack.isEmpty()) {
            boolean hasPlayer = false;
            for (Entity passenger : this.getPassengers()) {
                if (!(passenger instanceof Player)) continue;
                hasPlayer = true;
                break;
            }
            if (!hasPlayer || ((Boolean)SimplePlanesConfig.THIEF.get()).booleanValue()) {
                this.ejectPassengers();
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.getItem() == SimplePlanesItems.WRENCH.get()) {
            if (!this.level().isClientSide) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ModifyUpgradesContainer(id, player.getInventory(), this.getId()), (Component)Component.empty()), buf -> buf.writeVarInt(this.getId()));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.tryToAddUpgrade(player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }
        return player.getRootVehicle() == this.getRootVehicle() ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    protected boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getUpgradeFromItem(itemStack.getItem());
        return upgradeTypeOptional.map(upgradeType -> {
            if (this.canAddUpgrade((UpgradeType)upgradeType)) {
                Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                this.addUpgrade(playerEntity, itemStack, upgrade);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected void addUpgrade(Player playerEntity, ItemStack itemStack, Upgrade upgrade) {
        upgrade.onApply(itemStack);
        if (!playerEntity.isCreative()) {
            itemStack.shrink(1);
        }
        UpgradeType upgradeType = upgrade.getType();
        this.upgrades.put(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), upgrade);
        if (upgradeType.isEngine) {
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new UpdateUpgradePacket(true, SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), this.getId(), (ServerLevel)this.level()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void addUpgradeUsingWrench(ItemStack itemStack, Upgrade upgrade) {
        upgrade.onApply(itemStack);
        UpgradeType upgradeType = upgrade.getType();
        this.upgrades.put(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), upgrade);
        if (upgradeType.isEngine) {
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new UpdateUpgradePacket(true, SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), this.getId(), (ServerLevel)this.level()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean creativePlayer;
        Entity entity = source.getDirectEntity();
        if (entity == this.getControllingPassenger() && entity instanceof Player) {
            Player player = (Player)entity;
            Upgrade upgrade = this.upgrades.get(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.SHOOTER.get()));
            if (upgrade instanceof ShooterUpgrade) {
                ShooterUpgrade shooterUpgrade = (ShooterUpgrade)upgrade;
                shooterUpgrade.use(player);
            }
            return false;
        }
        if (this.getOnGround() && entity instanceof Player) {
            amount *= 3.0f;
        } else {
            Upgrade upgrade = this.upgrades.get(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.ARMOR.get()));
            if (upgrade instanceof ArmorUpgrade) {
                ArmorUpgrade armorUpgrade = (ArmorUpgrade)upgrade;
                amount = armorUpgrade.getReducedDamage(amount);
            }
        }
        this.setTimeSinceHit(20);
        this.setDamageTaken(this.getDamageTaken() + 10.0f * amount);
        if (this.isInvulnerableTo(source) || this.damageTimeout > 0) {
            return false;
        }
        if (this.level().isClientSide || this.isRemoved()) {
            return false;
        }
        int health = this.getHealth();
        if (health < 0) {
            return false;
        }
        this.setHealth((int)((float)health - amount));
        this.damageTimeout = 10;
        boolean isPlayer = source.getDirectEntity() instanceof Player;
        boolean bl = creativePlayer = isPlayer && ((Player)source.getEntity()).getAbilities().instabuild;
        if (creativePlayer) {
            this.kill();
        } else if (this.getOnGround() && this.getHealth() <= 0) {
            this.kill();
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                this.dropItem();
            }
        }
        return true;
    }

    private void explode() {
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 5, 1.0, 1.0, 1.0, 2.0);
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY(), this.getZ(), 10, 1.0, 1.0, 1.0, 1.0);
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
    }

    protected void dropItem() {
        ItemStack itemStack = this.getItemStack();
        this.spawnAtLocation(itemStack).setInvulnerable(true);
    }

    public boolean isPickable() {
        return true;
    }

    public void tick() {
        LivingEntity controllingPassenger;
        super.tick();
        if (Double.isNaN(this.getDeltaMovement().length())) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.prevRotationRoll = this.rotationRoll;
        if (this.level().isClientSide) {
            this.propellerRotationOld = this.propellerRotationNew;
            if (this.isPowered()) {
                int throttle = this.getThrottle();
                this.propellerRotationNew += (float)((double)throttle * 0.1);
            }
        }
        if (this.level().isClientSide && this.getHealth() <= 0) {
            this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, true, this.getX(), this.getY(), this.getZ(), 0.0, 0.005, 0.0);
        }
        if (this.level().isClientSide && this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.level().isClientSide && !this.isControlledByLocalInstance()) {
            this.tickLerp();
            this.setDeltaMovement(Vec3.ZERO);
            this.tickDeltaRotation(this.getQ_Client());
            this.tickUpgrades();
            return;
        }
        this.markHurt();
        TempMotionVars tempMotionVars = this.getMotionVars();
        if (this.isNoGravity()) {
            tempMotionVars.gravity = 0.0;
            tempMotionVars.maxLift = 0.0f;
            tempMotionVars.push = 0.0f;
            tempMotionVars.passiveEnginePush = 0.0f;
        }
        if ((controllingPassenger = this.getControllingPassenger()) instanceof Player) {
            Player playerEntity = (Player)controllingPassenger;
            tempMotionVars.moveForward = this.getMoveForward(playerEntity);
            tempMotionVars.moveStrafing = playerEntity.xxa;
        } else {
            tempMotionVars.moveForward = 0.0f;
            tempMotionVars.moveStrafing = 0.0f;
            this.setSprinting(false);
        }
        tempMotionVars.turnThreshold = (double)((Integer)SimplePlanesConfig.TURN_THRESHOLD.get()).intValue() / 100.0;
        if ((double)Math.abs(tempMotionVars.moveStrafing) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveStrafing = 0.0f;
        }
        Quaternionf q = this.level().isClientSide ? this.getQ_Client() : this.getQ();
        MathUtil.EulerAngles anglesOld = MathUtil.toEulerAngles(q).copy();
        Vec3 oldMotion = this.getDeltaMovement();
        if (this.level().isClientSide && this.isPowered() && this.getThrottle() > 0) {
            PlaneSound.tryToPlay(this);
        }
        tempMotionVars.push = 0.00625f * (float)this.getThrottle();
        if (this.getDeltaMovement().length() > 0.05) {
            q = this.tickRotateMotion(tempMotionVars, q, this.getDeltaMovement());
        }
        boolean doPitch = true;
        if (this.getOnGround() || this.isOnWater()) {
            doPitch = this.tickOnGround(tempMotionVars);
        } else {
            --this.onGroundTicks;
        }
        if (doPitch) {
            this.tickPitch(tempMotionVars);
        }
        this.tickYaw();
        this.tickMotion(tempMotionVars);
        this.tickRoll(tempMotionVars);
        this.tickUpgrades();
        if (this.onGroundTicks > -50 && oldMotion.length() < 0.002 && this.getDeltaMovement().length() < 0.002) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.reapplyPosition();
        if (!this.onGround() || MathUtil.getHorizontalDistanceSqr(this.getDeltaMovement()) > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            double speedBefore = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.getDeltaMovement()));
            boolean onGroundOld = this.onGround();
            Vec3 motion = this.getDeltaMovement();
            if (motion.lengthSqr() > 0.25 || this.getPitchUp() != 0) {
                this.setOnGround(true);
            }
            this.move(MoverType.SELF, motion);
            this.setOnGround(motion.y() == 0.0 ? onGroundOld : this.onGround());
            if (this.horizontalCollision && !this.level().isClientSide && this.onGroundTicks <= 0) {
                if (this.getHealth() <= 0) {
                    this.crash(16.0f);
                } else {
                    double speedAfter = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.getDeltaMovement()));
                    double speedDiff = speedBefore - speedAfter;
                    float f2 = (float)(speedDiff * 10.0 - 5.0);
                    if (f2 > 5.0f) {
                        this.crash(f2);
                    }
                }
            }
        }
        if (this.getHealth() <= 0 && this.onGround() && !this.isRemoved()) {
            this.crash(16.0f);
        }
        q.mul((Quaternionfc)Axis.ZP.rotationDegrees((float)((double)this.rotationRoll - anglesOld.roll)));
        q.mul((Quaternionfc)Axis.XN.rotationDegrees((float)((double)this.getXRot() - anglesOld.pitch)));
        q.mul((Quaternionfc)Axis.YP.rotationDegrees((float)((double)this.getYRot() - anglesOld.yaw)));
        q = MathUtil.normalizeQuaternionf(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        this.tickDeltaRotation(q);
        if (this.level().isClientSide && this.isControlledByLocalInstance()) {
            this.setQ_Client(q);
            PacketDistributor.sendToServer((CustomPacketPayload)new RotationPacket(this.getQ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ServerPlayer player = (ServerPlayer)this.getPlayer();
            if (player != null) {
                player.connection.aboveGroundVehicleTickCount = 0;
            }
        }
        if (this.damageTimeout > 0) {
            --this.damageTimeout;
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.level().isClientSide && this.getHealth() > this.getMaxHealth() & this.goldenHeartsTimeout > (this.getOnGround() ? 300 : 100)) {
            this.setHealth(this.getHealth() - 1);
            this.goldenHeartsTimeout = 0;
        }
        if (this.goldenHeartsTimeout < 1000 && this.isPowered()) {
            ++this.goldenHeartsTimeout;
        }
        this.tickLerp();
    }

    protected float getMoveForward(Player player) {
        return player.zza;
    }

    public void tickUpgrades() {
        ArrayList upgradesToRemove = new ArrayList();
        this.upgrades.forEach((rl, upgrade) -> {
            upgrade.tick();
            if (upgrade.removed) {
                upgradesToRemove.add(rl);
            }
        });
        for (ResourceLocation name : upgradesToRemove) {
            this.upgrades.remove(name);
        }
        if (!this.level().isClientSide && this.tickCount % this.networkUpdateInterval == 0) {
            this.upgrades.forEach((rl, upgrade) -> {
                if (upgrade.updateClient) {
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new UpdateUpgradePacket(false, (ResourceLocation)rl, this.getId(), (ServerLevel)this.level()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    upgrade.updateClient = false;
                }
            });
        }
    }

    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.PLANE_FUEL_COST.get();
    }

    protected TempMotionVars getMotionVars() {
        TEMP_MOTION_VARS.reset();
        PlaneEntity.TEMP_MOTION_VARS.maxPushSpeed = this.getMaxSpeed() * 10.0f;
        return TEMP_MOTION_VARS;
    }

    protected void tickDeltaRotation(Quaternionf q) {
        MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q);
        this.setXRot((float)angles.pitch);
        this.setYRot((float)angles.yaw);
        this.rotationRoll = (float)angles.roll;
        float d = (float)MathUtil.wrapSubtractDegrees(this.yRotO, this.getYRot());
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft *= 0.7f;
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = Mth.wrapDegrees((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(Math.abs(this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
    }

    protected float getRotationSpeedMultiplier() {
        return 1.0f;
    }

    protected void tickPitch(TempMotionVars tempMotionVars) {
        float pitch;
        if (this.getHealth() <= 0) {
            pitch = 10.0f;
        } else {
            if (this.getPitchUp() > 0) {
                this.pitchSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.getPitchUp() < 0) {
                this.pitchSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.pitchSpeed < 0.0f) {
                this.pitchSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.pitchSpeed > 0.0f) {
                this.pitchSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            }
            pitch = this.pitchSpeed = Mth.clamp((float)this.pitchSpeed, (float)(-5.0f * this.getRotationSpeedMultiplier()), (float)(5.0f * this.getRotationSpeedMultiplier()));
        }
        this.setXRot(this.getXRot() + pitch);
    }

    protected void tickYaw() {
        float yaw;
        if (this.getHealth() <= 0) {
            yaw = 10.0f;
        } else {
            if (this.getYawRight() > 0) {
                this.yawSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.getYawRight() < 0) {
                this.yawSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.yawSpeed < 0.0f) {
                this.yawSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.yawSpeed > 0.0f) {
                this.yawSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            }
            yaw = this.yawSpeed = Mth.clamp((float)this.yawSpeed, (float)(-2.5f * this.getRotationSpeedMultiplier()), (float)(2.5f * this.getRotationSpeedMultiplier()));
        }
        this.setYRot(this.getYRot() + yaw);
    }

    protected void tickRoll(TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.rotationRoll += this.getId() % 2 == 0 ? 10.0f : -10.0f;
            return;
        }
        double turn = 0.0;
        if (this.getOnGround() || this.isOnWater()) {
            turn = tempMotionVars.moveStrafing > 0.0f ? 3.0 : (tempMotionVars.moveStrafing == 0.0f ? 0.0 : -3.0);
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, 0.0f);
        } else {
            if (tempMotionVars.moveStrafing > 0.0f) {
                this.rollSpeed += 0.5f;
            } else if (tempMotionVars.moveStrafing < 0.0f) {
                this.rollSpeed -= 0.5f;
            } else if (this.rollSpeed < 0.0f) {
                this.rollSpeed += 0.5f;
            } else if (this.rollSpeed > 0.0f) {
                this.rollSpeed -= 0.5f;
            }
            this.rollSpeed = Mth.clamp((float)this.rollSpeed, (float)-5.0f, (float)5.0f);
            this.rotationRoll += this.rollSpeed;
        }
        this.setYRot((float)((double)this.getYRot() - turn));
    }

    protected void tickMotion(TempMotionVars tempMotionVars) {
        Vec3 pushVec;
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        Vec3 motion = this.getDeltaMovement();
        double speed = motion.length();
        double brakesMul = this.getThrottle() == 0 ? 5.0 : 1.0;
        speed -= (speed * speed * tempMotionVars.dragQuad + speed * tempMotionVars.dragMul + tempMotionVars.drag) * brakesMul;
        if ((speed = Math.max(speed, 0.0)) > tempMotionVars.maxSpeed) {
            speed = Mth.lerp((double)0.2, (double)speed, (double)tempMotionVars.maxSpeed);
        }
        if (speed == 0.0) {
            motion = Vec3.ZERO;
        }
        if (motion.length() > 0.0) {
            motion = motion.scale(speed / motion.length());
        }
        if ((pushVec = new Vec3(this.getTickPush(tempMotionVars))).length() != 0.0 && motion.length() > 0.1) {
            double dot = MathUtil.normalizedDotProduct(pushVec, motion);
            pushVec = pushVec.scale(Mth.clamp((double)(1.0 - dot * speed / (tempMotionVars.maxPushSpeed * ((double)tempMotionVars.push + 0.05))), (double)0.0, (double)2.0));
        }
        motion = motion.add(pushVec);
        motion = motion.add(0.0, tempMotionVars.gravity, 0.0);
        this.setDeltaMovement(motion);
    }

    protected Vector3f getTickPush(TempMotionVars tempMotionVars) {
        return this.transformPos(new Vector3f(0.0f, 0.0f, tempMotionVars.push));
    }

    protected boolean tickOnGround(TempMotionVars tempMotionVars) {
        this.notMovingTime = this.getDeltaMovement().lengthSqr() < 0.01 && this.getOnGround() ? ++this.notMovingTime : 0;
        if (this.notMovingTime > 200 && this.getHealth() < this.getMaxHealth() && this.getPlayer() != null) {
            this.setHealth(this.getHealth() + 1);
            this.notMovingTime = 100;
        }
        boolean speedingUp = true;
        this.onGroundTicks = this.onGroundTicks < 0 ? 5 : --this.onGroundTicks;
        float pitch = this.getGroundPitch();
        if (this.isPowered() && this.getPitchUp() > 0 || this.isOnWater()) {
            pitch = 0.0f;
        } else if (this.getDeltaMovement().length() > tempMotionVars.takeOffSpeed) {
            pitch /= 2.0f;
        }
        this.setXRot(MathUtil.lerpAngle(0.1f, this.getXRot(), pitch));
        if (MathUtil.degreesDifferenceAbs(this.getXRot(), 0.0) > 1.0 && this.getDeltaMovement().length() < 0.1) {
            tempMotionVars.push /= 5.0f;
        }
        if (this.getDeltaMovement().length() < tempMotionVars.takeOffSpeed) {
            speedingUp = false;
        }
        if (this.getPitchUp() < 0) {
            tempMotionVars.push = -tempMotionVars.groundPush;
        } else if (this.getPitchUp() > 0 && tempMotionVars.push < tempMotionVars.groundPush) {
            tempMotionVars.push = tempMotionVars.groundPush;
        }
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        BlockPos pos = new BlockPos((int)this.getX(), (int)(this.getY() - 1.0), (int)this.getZ());
        float f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this);
        tempMotionVars.dragMul *= (double)(20.0f * (3.0f - f));
        return speedingUp;
    }

    protected float getGroundPitch() {
        return 5.0f;
    }

    protected Quaternionf tickRotateMotion(TempMotionVars tempMotionVars, Quaternionf q, Vec3 motion) {
        float d;
        float yaw = MathUtil.getYaw(motion);
        float pitch = MathUtil.getPitch(motion);
        if (MathUtil.degreesDifferenceAbs(yaw, this.getYRot()) > 5.0 && (this.getOnGround() || this.isOnWater())) {
            this.setDeltaMovement(motion.scale(0.98));
        }
        if ((d = (float)MathUtil.degreesDifferenceAbs(pitch, this.getXRot())) > 180.0f) {
            d -= 180.0f;
        }
        d /= 60.0f;
        d = Math.min(1.0f, d);
        d *= d;
        d = 1.0f - d;
        double speed = this.getDeltaMovement().length();
        double lift = Math.min(speed * tempMotionVars.liftFactor, (double)tempMotionVars.maxLift) * (double)d;
        if (this.getHealth() <= 0) {
            lift = 0.0;
        }
        this.setDeltaMovement(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.getYRot()), (double)MathUtil.lerpAngle180(tempMotionVars.pitchToMotion * d, pitch, this.getXRot()) + lift, speed));
        if (!this.getOnGround() && !this.isOnWater() && motion.length() > 0.1) {
            if (MathUtil.degreesDifferenceAbs(pitch, this.getXRot()) > 90.0) {
                pitch = Mth.wrapDegrees((float)(pitch + 180.0f));
            }
            if (Math.abs(this.getXRot()) < 85.0f) {
                yaw = MathUtil.getYaw(this.getDeltaMovement());
                if (MathUtil.degreesDifferenceAbs(yaw, this.getYRot()) > 90.0) {
                    yaw -= 180.0f;
                }
                Quaternionf q1 = MathUtil.toQuaternionf(yaw, pitch, this.rotationRoll);
                q = MathUtil.lerpQ(tempMotionVars.motionToRotation, q, q1);
            }
        }
        return q;
    }

    public Vector3f transformPos(Vector3f relPos) {
        MathUtil.EulerAngles angles = MathUtil.toEulerAngles(this.getQ_Client());
        angles.yaw = -angles.yaw;
        angles.roll = -angles.roll;
        relPos.rotate((Quaternionfc)MathUtil.toQuaternionf(angles.yaw, angles.pitch, angles.roll));
        return relPos;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("max_speed")) {
            this.entityData.set(MAX_SPEED, (Object)Float.valueOf(compound.getFloat("max_speed")));
        }
        if (compound.contains("max_health")) {
            int maxHealth = compound.getInt("max_health");
            if (maxHealth <= 0) {
                maxHealth = 20;
            }
            this.entityData.set(MAX_HEALTH, (Object)maxHealth);
        }
        if (compound.contains("health")) {
            int health = compound.getInt("health");
            this.entityData.set(HEALTH, (Object)health);
        }
        if (compound.contains("material")) {
            this.setMaterial(compound.getString("material"));
        }
        if (compound.contains("upgrades")) {
            CompoundTag upgradesNBT = compound.getCompound("upgrades");
            this.deserializeUpgrades(upgradesNBT);
        }
        this.setQ(MathUtil.toQuaternionf(this.getYRot(), this.getXRot(), 0.0));
    }

    private void deserializeUpgrades(CompoundTag upgradesNBT) {
        for (String key : upgradesNBT.getAllKeys()) {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPE.get(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.getCompound(key));
            this.upgrades.put(resourceLocation, upgrade);
            if (!upgradeType.isEngine) continue;
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("health", ((Integer)this.entityData.get(HEALTH)).intValue());
        compound.putInt("max_health", ((Integer)this.entityData.get(MAX_HEALTH)).intValue());
        compound.putFloat("max_speed", ((Float)this.entityData.get(MAX_SPEED)).floatValue());
        compound.putString("material", (String)this.entityData.get(MATERIAL));
        compound.put("upgrades", (Tag)this.getUpgradesNBT());
    }

    private CompoundTag getUpgradesNBT() {
        CompoundTag upgradesNBT = new CompoundTag();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.put(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgrade.getType()).toString(), upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean canRide(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        if (type == NeoForgeMod.EMPTY_TYPE.value()) {
            return true;
        }
        return type == NeoForgeMod.WATER_TYPE.value() && this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.FLOATY_BEDDING.get()));
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (MATERIAL.equals(key) && this.level().isClientSide()) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)((String)this.entityData.get(MATERIAL))));
            this.planksMaterial = block == null ? Blocks.OAK_PLANKS : block;
        } else if (Q.equals(key) && this.level().isClientSide() && !this.isControlledByLocalInstance()) {
            if (this.firstTick) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public float getPassengersRidingOffset() {
        return 0.5f;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE) && this.planksMaterial.builtInRegistryHolder().is(FIREPROOF_MATERIALS_TAG)) {
            return true;
        }
        if (source.getDirectEntity() != null && source.getDirectEntity().isPassengerOfSameVehicle((Entity)this)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean fireImmune() {
        return this.planksMaterial.builtInRegistryHolder().is(FIREPROOF_MATERIALS_TAG);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (onGroundIn || this.isOnWater()) {
            double y1 = this.transformPos(new Vector3f(0.0f, 1.0f, 0.0f)).y();
            if (y1 < Math.cos(Math.toRadians(this.getLandingAngle()))) {
                state.getBlock().fallOn(this.level(), state, pos, (Entity)this, (float)(this.getDeltaMovement().length() * 5.0));
            }
            this.fallDistance = 0.0f;
        }
    }

    protected int getLandingAngle() {
        return 30;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource p_146830_) {
        if (MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0) > 45.0) {
            this.crash(fallDistance * damageMultiplier);
        }
        return false;
    }

    public void crash(float damage) {
        if (!this.level().isClientSide && this.isAlive()) {
            this.explode();
            this.kill();
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                this.dropItem();
            }
        }
    }

    public boolean isCreative() {
        return this.getControllingPassenger() instanceof Player && ((Player)this.getControllingPassenger()).isCreative();
    }

    public boolean getOnGround() {
        return this.onGround() || this.onGroundTicks > 1;
    }

    public boolean isOnWater() {
        Vec3 pos = this.position();
        return this.level().getBlockState(new BlockPos((int)pos.x, (int)Math.floor(pos.y + 0.4), (int)pos.z)).getFluidState().is(FluidTags.WATER);
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.isEngine && this.engineUpgrade != null) {
            return false;
        }
        return !this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType));
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.getPassengers().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset(), 0.0f));
            moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
        } else if (index == 1) {
            Vector3f pos = this.transformPos(new Vector3f(-1.0f, this.getPassengersRidingOffset(), -1.3f));
            moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
        } else if (index == 2) {
            Vector3f pos = this.transformPos(new Vector3f(1.0f, this.getPassengersRidingOffset(), -1.3f));
            moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
        }
    }

    protected void positionRiderGeneric(Entity passenger) {
        boolean local;
        boolean bl = local = passenger instanceof Player && ((Player)passenger).isLocalPlayer();
        if (this.hasPassenger(passenger) && !local) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.setYHeadRot(entityToUpdate.getYHeadRot() + this.deltaRotation);
        entityToUpdate.yRotO += this.deltaRotation;
        entityToUpdate.setYBodyRot(this.getYRot());
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Player player;
        if (this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.FOLDING.get())) && livingEntity instanceof Player && !(player = (Player)livingEntity).isCreative() && this.getPassengers().isEmpty() && this.isAlive()) {
            ItemStack itemStack = this.getItemStack();
            if (!player.addItem(itemStack)) {
                player.drop(itemStack, false);
            }
            this.kill();
            return player.position();
        }
        if (this.getPassengers().isEmpty()) {
            this.setThrottle(0);
            this.setPitchUp((byte)0);
            this.setYawRight((byte)0);
        }
        return super.getDismountLocationForPassenger(livingEntity);
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.getItem().getDefaultInstance();
        CompoundTag compound = new CompoundTag();
        this.addAdditionalSaveData(compound);
        compound.putInt("health", ((Integer)this.entityData.get(MAX_HEALTH)).intValue());
        compound.putBoolean("Used", true);
        itemStack.set(SimplePlanesComponents.ENTITY_TAG, (Object)compound);
        return itemStack;
    }

    protected Item getItem() {
        return SimplePlanesItems.PLANE_ITEM.get();
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double d1 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double d2 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.setPos(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.getX() && y == this.getY() && z == this.getZ()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void absMoveTo(double x, double y, double z, float yaw, float pitch) {
        double d0 = Mth.clamp((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = Mth.clamp((double)z, (double)-3.0E7, (double)3.0E7);
        this.xOld = d0;
        this.yOld = y;
        this.zOld = d1;
        this.setPos(d0, y, d1);
        this.setYRot(yaw % 360.0f);
        this.setXRot(pitch % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.absMoveTo(this.lerpX, this.lerpY, this.lerpZ, this.getYRot(), this.getXRot());
        }
    }

    public Player getPlayer() {
        if (this.getControllingPassenger() instanceof Player) {
            return (Player)this.getControllingPassenger();
        }
        return null;
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.entityData.set(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.entityData.set(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.entityData.get(DAMAGE_TAKEN)).floatValue();
    }

    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.PLANE_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    public void writeUpdateUpgradePacket(ResourceLocation upgradeID, FriendlyByteBuf buffer) {
        this.upgrades.get(upgradeID).writePacket(new RegistryFriendlyByteBuf((ByteBuf)buffer, this.level().registryAccess(), ConnectionType.NEOFORGE));
    }

    public void readUpdateUpgradePacket(ResourceLocation upgradeID, ByteBuf buffer, boolean newUpgrade) {
        if (newUpgrade) {
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPE.get(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
        }
        this.upgrades.get(upgradeID).readPacket(new RegistryFriendlyByteBuf(buffer, this.registryAccess(), ConnectionType.NEOFORGE));
    }

    public <T> T getCap(BaseCapability<T, ?> cap) {
        for (Upgrade upgrade : this.upgrades.values()) {
            T instance = upgrade.getCap(cap);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        Collection<Upgrade> upgrades = this.upgrades.values();
        buffer.writeVarInt(upgrades.size());
        for (Upgrade upgrade : upgrades) {
            ResourceLocation upgradeID = SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgrade.getType());
            buffer.writeResourceLocation(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        int upgradesSize = additionalData.readVarInt();
        for (int i = 0; i < upgradesSize; ++i) {
            ResourceLocation upgradeID = additionalData.readResourceLocation();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPE.get(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
            upgrade.readPacket(additionalData);
        }
    }

    public void removeUpgrade(ResourceLocation upgradeID) {
        Upgrade upgrade = this.upgrades.remove(upgradeID);
        if (upgrade != null) {
            upgrade.onRemoved();
            upgrade.remove();
            if (!this.level().isClientSide) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SUpgradeRemovedPacket(upgradeID, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void changeThrottle(ChangeThrottlePacket.Direction type) {
        int throttle = this.getThrottle();
        if (type == ChangeThrottlePacket.Direction.UP) {
            if (throttle < 5 || this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.BOOSTER.get())) && throttle < 10) {
                this.setThrottle(throttle + 1);
            }
        } else if (throttle > 0) {
            this.setThrottle(throttle - 1);
        }
    }

    public int getThrottle() {
        return (Integer)this.entityData.get(THROTTLE);
    }

    public void setThrottle(int value) {
        this.entityData.set(THROTTLE, (Object)value);
    }

    public byte getPitchUp() {
        return (Byte)this.entityData.get(PITCH_UP);
    }

    public void setPitchUp(byte pitchUp) {
        this.entityData.set(PITCH_UP, (Object)pitchUp);
    }

    public byte getYawRight() {
        return (Byte)this.entityData.get(YAW_RIGHT);
    }

    public void setYawRight(byte yawRight) {
        this.entityData.set(YAW_RIGHT, (Object)yawRight);
    }

    public void openContainer(Player player, int containerID) {
        if (containerID == 0) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, playerIn) -> new PlaneInventoryContainer(id, inventory, this), this.getName()), buffer -> buffer.writeVarInt(this.getId()));
        } else {
            int id2 = 0;
            for (Upgrade upgrade : this.upgrades.values()) {
                LargeUpgrade largeUpgrade;
                if (!(upgrade instanceof LargeUpgrade) || !(largeUpgrade = (LargeUpgrade)upgrade).hasStorage() || containerID != ++id2) continue;
                largeUpgrade.openStorageGui(player, id2);
            }
        }
    }

    public void dropPayload() {
    }

    protected static class TempMotionVars {
        public float moveForward;
        public double turnThreshold;
        public float moveStrafing;
        double maxSpeed;
        double maxPushSpeed;
        double takeOffSpeed;
        float maxLift;
        double liftFactor;
        double gravity;
        double drag;
        double dragMul;
        double dragQuad;
        float push;
        float groundPush;
        float passiveEnginePush;
        float motionToRotation;
        float pitchToMotion;
        float yawMultiplayer;

        public TempMotionVars() {
            this.reset();
        }

        public void reset() {
            this.moveForward = 0.0f;
            this.turnThreshold = 0.0;
            this.moveStrafing = 0.0f;
            this.maxSpeed = 3.0;
            this.takeOffSpeed = 0.3;
            this.maxLift = 2.0f;
            this.liftFactor = 10.0;
            this.gravity = -0.03;
            this.drag = 0.001;
            this.dragMul = 5.0E-4;
            this.dragQuad = 0.001;
            this.push = 0.0f;
            this.groundPush = 0.01f;
            this.passiveEnginePush = 0.025f;
            this.motionToRotation = 0.05f;
            this.pitchToMotion = 0.2f;
            this.yawMultiplayer = 0.5f;
        }
    }
}

