/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.container;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.przemyk.simpleplanes.container.PlaneCraftingResultSlot;
import xyz.przemyk.simpleplanes.network.CycleItemsPacket;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesComponents;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRecipes;

public class PlaneWorkbenchContainer
extends AbstractContainerMenu {
    public static final ResourceLocation PLANE_MATERIALS = ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"plane_materials");
    public static final TagKey<Block> PLANE_MATERIALS_TAG = BlockTags.create((ResourceLocation)PLANE_MATERIALS);
    private final ItemStackHandler itemHandler;
    private final ItemStackHandler resultItemHandler = new ItemStackHandler();
    private final ContainerLevelAccess usabilityTest;
    private final Player player;
    private final DataSlot selectedRecipe;
    private final CompoundTag resultItemTag = new CompoundTag();
    private final List<RecipeHolder<PlaneWorkbenchRecipe>> recipeList;

    public PlaneWorkbenchContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, BlockPos.ZERO, new ItemStackHandler(2), DataSlot.standalone());
    }

    public PlaneWorkbenchContainer(int id, Inventory playerInventory, BlockPos blockPos, ItemStackHandler itemHandler, DataSlot selectedRecipe) {
        super(SimplePlanesContainers.PLANE_WORKBENCH.get(), id);
        this.player = playerInventory.player;
        this.itemHandler = itemHandler;
        this.usabilityTest = ContainerLevelAccess.create((Level)this.player.level(), (BlockPos)blockPos);
        this.recipeList = this.player.level().getRecipeManager().getAllRecipesFor(SimplePlanesRecipes.PLANE_WORKBENCH_RECIPE_TYPE.get());
        this.selectedRecipe = selectedRecipe;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 28, 47));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, 75, 47));
        this.addSlot((Slot)new PlaneCraftingResultSlot(this.player, this, (IItemHandler)this.resultItemHandler, 0, 134, 47));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(selectedRecipe);
        this.updateCraftingResult();
    }

    public void cycleItems(CycleItemsPacket.Direction direction) {
        int prevSelectedRecipe = this.selectedRecipe.get();
        ItemStack ingredient = this.itemHandler.getStackInSlot(0);
        ItemStack material = this.itemHandler.getStackInSlot(1);
        switch (direction) {
            case CRAFTING_LEFT: {
                do {
                    if (this.selectedRecipe.get() == 0) {
                        this.selectedRecipe.set(this.recipeList.size() - 1);
                        continue;
                    }
                    this.selectedRecipe.set(this.selectedRecipe.get() - 1);
                } while (this.selectedRecipe.get() != prevSelectedRecipe && !((PlaneWorkbenchRecipe)this.recipeList.get(this.selectedRecipe.get()).value()).canCraft(ingredient, material));
                break;
            }
            case CRAFTING_RIGHT: {
                do {
                    if (this.selectedRecipe.get() == this.recipeList.size() - 1) {
                        this.selectedRecipe.set(0);
                        continue;
                    }
                    this.selectedRecipe.set(this.selectedRecipe.get() + 1);
                } while (this.selectedRecipe.get() != prevSelectedRecipe && !((PlaneWorkbenchRecipe)this.recipeList.get(this.selectedRecipe.get()).value()).canCraft(ingredient, material));
            }
        }
        this.updateCraftingResult();
    }

    public void onCrafting() {
        if (!this.player.level().isClientSide) {
            PlaneWorkbenchRecipe recipe = (PlaneWorkbenchRecipe)this.recipeList.get(this.selectedRecipe.get()).value();
            this.itemHandler.extractItem(0, recipe.ingredientAmount(), false);
            this.itemHandler.extractItem(1, recipe.materialAmount(), false);
            this.updateCraftingResult();
        }
    }

    protected void updateCraftingResult() {
        if (!this.player.level().isClientSide) {
            BlockItem blockItem;
            ServerPlayer serverPlayerEntity = (ServerPlayer)this.player;
            ItemStack result = ItemStack.EMPTY;
            ItemStack ingredientStack = this.itemHandler.getStackInSlot(0);
            ItemStack materialStack = this.itemHandler.getStackInSlot(1);
            Item materialItem = materialStack.getItem();
            PlaneWorkbenchRecipe recipe = (PlaneWorkbenchRecipe)this.recipeList.get(this.selectedRecipe.get()).value();
            if (recipe.canCraft(ingredientStack, materialStack) && materialItem instanceof BlockItem && (blockItem = (BlockItem)materialItem).getBlock().builtInRegistryHolder().is(PLANE_MATERIALS_TAG)) {
                result = recipe.result().copy();
                Block block = blockItem.getBlock();
                this.resultItemTag.putString("material", BuiltInRegistries.BLOCK.getKey((Object)block).toString());
                result.set(SimplePlanesComponents.ENTITY_TAG, (Object)this.resultItemTag);
            }
            this.resultItemHandler.setStackInSlot(0, result);
            serverPlayerEntity.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 2, result));
        }
    }

    public boolean stillValid(Player playerIn) {
        return PlaneWorkbenchContainer.stillValid((ContainerLevelAccess)this.usabilityTest, (Player)playerIn, (Block)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get());
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        super.clicked(slotId, dragType, clickTypeIn, player);
        this.updateCraftingResult();
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack inputItemStack = slot.getItem();
            ItemStack originalItemStack = inputItemStack.copy();
            if (index == 2) {
                inputItemStack.getItem().onCraftedBy(inputItemStack, playerIn.level(), playerIn);
                if (!this.moveItemStackTo(inputItemStack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(inputItemStack, originalItemStack);
            } else if (index >= 3 && index < 39 ? !this.moveItemStackTo(inputItemStack, 0, 2, false) && (index < 30 ? !this.moveItemStackTo(inputItemStack, 30, 39, false) : !this.moveItemStackTo(inputItemStack, 3, 30, false)) : !this.moveItemStackTo(inputItemStack, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (inputItemStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (inputItemStack.getCount() == originalItemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, inputItemStack);
            if (index == 2) {
                playerIn.drop(inputItemStack, false);
            }
        }
        return ItemStack.EMPTY;
    }
}

