/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import xyz.przemyk.simpleplanes.container.ModifyUpgradesContainer;
import xyz.przemyk.simpleplanes.entities.CargoPlaneEntity;

public class ModifyUpgradesScreen
extends AbstractContainerScreen<ModifyUpgradesContainer> {
    public static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"textures/gui/modify_upgrades.png");
    public static final Component UPGRADES_TOOLTIP = Component.translatable((String)"simpleplanes.add_upgrades");
    public static final Component CARGO_TOOLTIP = Component.translatable((String)"simpleplanes.add_cargo");

    public ModifyUpgradesScreen(ModifyUpgradesContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageHeight = 184;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.hoveredSlot != null && this.hoveredSlot.getItem().isEmpty()) {
            if (this.hoveredSlot.index < 6) {
                guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)UPGRADES_TOOLTIP, 115), mouseX, mouseY);
            } else if (this.hoveredSlot.index < 14) {
                guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)CARGO_TOOLTIP, 115), mouseX, mouseY);
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI, i, j, 0, 0, this.imageWidth, this.imageHeight);
        if (((ModifyUpgradesContainer)this.menu).planeEntity != null) {
            guiGraphics.enableScissor(i + 62, j + 8, i + 168, j + 69);
            ModifyUpgradesScreen.renderEntityInInventory(guiGraphics, this.leftPos + 115, this.topPos + 50, ((ModifyUpgradesContainer)this.menu).planeEntity instanceof CargoPlaneEntity ? 6 : 11, new Quaternionf().rotateXYZ(0.3f, ((float)this.minecraft.level.getGameTime() + partialTicks) / 20.0f, (float)Math.PI), null, ((ModifyUpgradesContainer)this.menu).planeEntity);
            guiGraphics.disableScissor();
            if (((ModifyUpgradesContainer)this.menu).planeEntity instanceof CargoPlaneEntity) {
                guiGraphics.blit(GUI, i + 25, j + 74, 25, 101, 144, 18);
            }
        }
        if (((ModifyUpgradesContainer)this.menu).errorSlot != -1) {
            Slot slot = (Slot)((ModifyUpgradesContainer)this.menu).slots.get(((ModifyUpgradesContainer)this.menu).errorSlot);
            guiGraphics.blit(GUI, i + slot.x - 1, j + slot.y - 1, 176, 76, 18, 18);
        }
    }

    public static void renderEntityInInventory(GuiGraphics guiGraphics, int x, int y, int scale, Quaternionf quaternionf, @Nullable Quaternionf quaternionf1, Entity entity) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x, (double)y, 50.0);
        guiGraphics.pose().mulPose(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        guiGraphics.pose().mulPose(quaternionf);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (quaternionf1 != null) {
            quaternionf1.conjugate();
            entityrenderdispatcher.overrideCameraOrientation(quaternionf1);
        }
        entityrenderdispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0));
        guiGraphics.flush();
        entityrenderdispatcher.setRenderShadow(true);
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }
}

