/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.minimaps;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.platform.Services;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.option.MinimapOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import xaero.common.HudMod;
import xaero.lib.client.gui.ScreenBase;

public class CurrentMinimap {
    private static boolean minimapLoaded(Minimap minimap) {
        String modId = minimap.getModId();
        return Services.PLATFORM.isModLoaded(modId);
    }

    public static boolean xaeroLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.XAERO) || CurrentMinimap.minimapLoaded(Minimap.XAERO_FAIRPLAY);
    }

    public static boolean journeyMapLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.JOURNEYMAP);
    }

    public static boolean ftbChunksLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.FTB_CHUNKS);
    }

    public static boolean mapAtlasesLoaded() {
        return CurrentMinimap.minimapLoaded(Minimap.MAP_ATLASES);
    }

    private static List<Minimap> getLoadedMinimaps() {
        ArrayList<Minimap> values = new ArrayList<Minimap>(List.of(Minimap.values()));
        ArrayList<Minimap> loaded = new ArrayList<Minimap>();
        values.forEach(minimaps -> {
            if (CurrentMinimap.minimapLoaded(minimaps)) {
                loaded.add((Minimap)((Object)minimaps));
            }
        });
        return loaded;
    }

    public static boolean noMinimapLoaded() {
        return CurrentMinimap.getLoadedMinimaps().isEmpty();
    }

    public static boolean hiddenMinimap(Minimap minimap) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return false;
        }
        switch (minimap.ordinal()) {
            case 2: {
                MiniMapProperties properties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
                return properties.enabled.get() == false || !properties.isActive() && UIManager.INSTANCE.getMiniMap().isDrawingInPreviewMode() || mc.player.isScoping() || mc.screen != null && !(mc.screen instanceof ChatScreen) && !(mc.screen instanceof MinimapOptions);
            }
            case 3: {
                return (Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false || mc.getDebugOverlay().showDebugScreen();
            }
            case 0: 
            case 1: {
                return !HudMod.INSTANCE.getSettings().getMinimap() || mc.getDebugOverlay().showDebugScreen() || mc.screen != null && !(mc.screen instanceof ChatScreen) && !(mc.screen instanceof DeathScreen) && !(mc.screen instanceof ScreenBase);
            }
            case 4: {
                return Services.MINIMAP.hideMapAtlases();
            }
        }
        return false;
    }

    public static boolean allMinimapsHidden() {
        List<Minimap> loadedMinimaps = CurrentMinimap.getLoadedMinimaps();
        ArrayList<Boolean> hiddenMinimaps = new ArrayList<Boolean>();
        loadedMinimaps.forEach(minimap -> hiddenMinimaps.add(CurrentMinimap.hiddenMinimap(minimap)));
        return Common.allTrue(hiddenMinimaps);
    }

    public static boolean shouldDrawMinimapHud(Minimap minimap) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return false;
        }
        boolean enabled = SeasonHudClient.getEnableMod() && SeasonHudClient.getEnableMinimapIntegration();
        boolean hiddenMinimap = Common.hideHudInCurrentDimension() || CurrentMinimap.hiddenMinimap(minimap);
        return enabled && Calendar.validNeedCalendar() && !mc.options.hideGui && !hiddenMinimap;
    }

    public static enum Minimap {
        XAERO("xaerominimap"),
        XAERO_FAIRPLAY("xaerominimapfair"),
        JOURNEYMAP("journeymap"),
        FTB_CHUNKS("ftbchunks"),
        MAP_ATLASES("map_atlases");

        private final String modId;

        private Minimap(String modId) {
            this.modId = modId;
        }

        public String getModId() {
            return this.modId;
        }
    }
}

