/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BasicSlider
extends AbstractSliderButton {
    public static final int SLIDER_PADDING = 2;
    protected static final ResourceLocation SLIDER_LOCATION = Common.location("textures/gui/slider.png");
    protected boolean drawString;
    protected boolean canChangeValue;
    protected double minValue;
    protected double maxValue;
    protected double defaultValue;
    protected double stepSize;
    protected ChatFormatting textColor;
    private DecimalFormat format;

    private BasicSlider(int x, int y, int width, int height, boolean drawString, double initial) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.drawString = drawString;
        this.value = this.snapToNearest(initial);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision, ChatFormatting textColor) {
        this(x, y, width, height, drawString, initial);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.value = this.snapToNearest((initial - minValue) / (maxValue - minValue));
        this.stepSize = Math.abs(stepSize);
        this.textColor = textColor;
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.equal((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.updateMessage();
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, ChatFormatting textColor) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, textColor);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, stepSize, precision, ChatFormatting.WHITE);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, ChatFormatting.WHITE);
    }

    public void onRightClick() {
        this.setValue(this.defaultValue);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean rightClicked;
        if (this.active && this.visible && mouseButton == 1 && (rightClicked = this.clicked(mouseX, mouseY))) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.onRightClick();
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public int getTextureY() {
        int i = this.isFocused() && !this.canChangeValue ? 1 : 0;
        return i * 20;
    }

    public int getHandleTextureY() {
        int i = !this.isHovered && !this.canChangeValue ? 2 : 3;
        return i * 20;
    }

    public int getFgColor() {
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    protected double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.clamp((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.lerp((double)Mth.clamp((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.clamp((double)value, (double)this.maxValue, (double)this.minValue) : Mth.clamp((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.map((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.value = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.updateMessage();
    }

    public double getValueDouble() {
        return (double)Math.round(this.getValue() * 10.0) / 10.0;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void setSliderValue(double value) {
        double oldValue = this.value;
        this.value = this.snapToNearest(value);
        if (!Mth.equal((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    protected void applyValue() {
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                bl = !bl;
            }
            float f2 = f = bl ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.width - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((Component)Common.literalText(this.getValueString()));
        } else {
            this.setMessage((Component)Component.empty());
        }
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
    }
}

