/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.datagen.loot;

import com.phantomwing.rusticdelight.block.ModBlocks;
import com.phantomwing.rusticdelight.block.custom.BellPepperCropBlock;
import com.phantomwing.rusticdelight.block.custom.CoffeeCropBlock;
import com.phantomwing.rusticdelight.block.custom.CottonCropBlock;
import com.phantomwing.rusticdelight.block.custom.PancakeBlock;
import com.phantomwing.rusticdelight.block.custom.RiceRollRoyaleBlock;
import com.phantomwing.rusticdelight.item.ModItems;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.PieBlock;

public class BlockLootTables
extends BlockLootSubProvider {
    public BlockLootTables(HolderLookup.Provider lookupProvider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
    }

    protected void generate() {
        this.dropCrop((Block)ModBlocks.COTTON_CROP.get(), CottonCropBlock.AGE, 3, (ItemLike)ModItems.COTTON_SEEDS, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f), (ItemLike)ModItems.COTTON_BOLL, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f));
        this.dropBellPepperCrop((Block)ModBlocks.BELL_PEPPER_CROP.get());
        this.dropCrop((Block)ModBlocks.COFFEE_CROP.get(), CoffeeCropBlock.AGE, 5, (ItemLike)ModItems.COFFEE_BEANS, (NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f), (ItemLike)ModItems.COFFEE_BEANS, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f));
        this.dropWildCrop((Block)ModBlocks.WILD_COTTON.get(), (ItemLike)ModItems.COTTON_SEEDS, (ItemLike)ModItems.COTTON_BOLL);
        this.dropWildCrop((Block)ModBlocks.WILD_BELL_PEPPERS.get(), (ItemLike)ModItems.BELL_PEPPER_SEEDS, (ItemLike)ModItems.BELL_PEPPER_RED);
        this.dropWildCrop((Block)ModBlocks.WILD_COFFEE.get(), (ItemLike)ModItems.COFFEE_BEANS, (ItemLike)ModItems.COFFEE_BEANS);
        this.dropPottedFlower((Block)ModBlocks.POTTED_WILD_COTTON.get(), (Block)ModBlocks.WILD_COTTON.get());
        this.dropPottedFlower((Block)ModBlocks.POTTED_WILD_BELL_PEPPERS.get(), (Block)ModBlocks.WILD_BELL_PEPPERS.get());
        this.dropPottedFlower((Block)ModBlocks.POTTED_WILD_COFFEE.get(), (Block)ModBlocks.WILD_COFFEE.get());
        this.dropSelf((Block)ModBlocks.COTTON_SEEDS_BAG.get());
        this.dropSelf((Block)ModBlocks.BELL_PEPPER_SEEDS_BAG.get());
        this.dropSelf((Block)ModBlocks.COFFEE_BEANS_BAG.get());
        this.dropSelf((Block)ModBlocks.ROASTED_COFFEE_BEANS_BAG.get());
        this.dropSelf((Block)ModBlocks.COTTON_BOLL_CRATE.get());
        this.dropSelf((Block)ModBlocks.BELL_PEPPER_GREEN_CRATE.get());
        this.dropSelf((Block)ModBlocks.BELL_PEPPER_YELLOW_CRATE.get());
        this.dropSelf((Block)ModBlocks.BELL_PEPPER_RED_CRATE.get());
        this.dropFoodBlock((Block)ModBlocks.SYRUP_CHEESECAKE.get(), PieBlock.BITES);
        this.dropFoodBlock((Block)ModBlocks.CHERRY_BLOSSOM_CHEESECAKE.get(), PieBlock.BITES);
        this.dropFoodBlock((Block)ModBlocks.PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.HONEY_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.CHOCOLATE_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.CHERRY_BLOSSOM_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.VEGETABLE_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.PUMPKIN_PANCAKES.get(), PancakeBlock.SERVINGS, (ItemLike)Items.BOWL);
        this.dropFoodBlock((Block)ModBlocks.RICE_ROLL_ROYALE.get(), RiceRollRoyaleBlock.ROLL_SERVINGS, 8, (ItemLike)Items.BOWL);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(e -> (Block)e.value()).toList();
    }

    private void dropPottedFlower(Block pottedBlock, Block flowerBlock) {
        this.add(pottedBlock, this.createPotFlowerItemTable((ItemLike)flowerBlock));
    }

    private void dropCrop(Block block, IntegerProperty age, int maxAge, ItemLike seedsItem, NumberProvider seedsCount, ItemLike cropItem, NumberProvider cropCount) {
        this.add(block, blockParam -> this.createCropDrops((Block)blockParam, age, maxAge, seedsItem, seedsCount, cropItem, cropCount));
    }

    private void dropBellPepperCrop(Block block) {
        this.add(block, this::createBellPepperDrops);
    }

    private void dropFoodBlock(Block block, IntegerProperty servings) {
        this.add(block, blockParam -> this.createFoodBlockDrops((Block)blockParam, servings, 0, null));
    }

    private void dropFoodBlock(Block block, IntegerProperty servings, ItemLike containerItem) {
        this.add(block, blockParam -> this.createFoodBlockDrops((Block)blockParam, servings, 0, containerItem));
    }

    private void dropFoodBlock(Block block, IntegerProperty servings, int defaultServings, ItemLike containerItem) {
        this.add(block, blockParam -> this.createFoodBlockDrops((Block)blockParam, servings, defaultServings, containerItem));
    }

    private LootTable.Builder createCropDrops(Block cropBlock, IntegerProperty age, int maxAge, ItemLike seedsItem, NumberProvider seedsCount, ItemLike cropItem, NumberProvider cropCount) {
        HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootItemBlockStatePropertyCondition.Builder dropGrownCropCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)age, maxAge));
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)cropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when(InvertedLootItemCondition.invert((LootItemCondition.Builder)dropGrownCropCondition)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)seedsCount)).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)cropItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)cropCount)).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))))));
    }

    private LootTable.Builder createBellPepperDrops(Block cropBlock) {
        HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootItemBlockStatePropertyCondition.Builder dropGrownCropCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BellPepperCropBlock.AGE, 7));
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)cropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when(InvertedLootItemCondition.invert((LootItemCondition.Builder)dropGrownCropCondition)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_SEEDS.get())))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_SEEDS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_RED.get())).setWeight(6)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_GREEN.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_YELLOW.get())))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)dropGrownCropCondition).when(LootItemRandomChanceCondition.randomChance((float)0.15f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_GREEN.get())))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)dropGrownCropCondition).when(LootItemRandomChanceCondition.randomChance((float)0.15f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BELL_PEPPER_YELLOW.get())))));
    }

    private void dropWildCrop(Block block, ItemLike seedsItem, ItemLike cropItem) {
        this.add(block, blockParam -> this.createWildCropDrops((Block)blockParam, seedsItem, cropItem));
    }

    private LootTable.Builder createWildCropDrops(Block block, ItemLike seedsItem, ItemLike cropItem) {
        HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasShearsOrSilkTouch()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(LootPool.lootPool().when(this.doesNotHaveShearsOrSilkTouch()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{this.doesNotHaveShearsOrSilkTouch(), LootItemRandomChanceCondition.randomChance((float)0.3f)})).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)cropItem))));
    }

    private LootTable.Builder createFoodBlockDrops(Block block, IntegerProperty servings, int defaultServings, ItemLike containerItem) {
        LootItemBlockStatePropertyCondition.Builder noServingsTaken = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)servings, defaultServings));
        LootTable.Builder lootTable = (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)noServingsTaken).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
        if (containerItem != null) {
            lootTable.withPool(LootPool.lootPool().when(InvertedLootItemCondition.invert((LootItemCondition.Builder)noServingsTaken)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)containerItem)));
        }
        return lootTable;
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }
}

