/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.utils;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class ShapeUtils {
    public static Map<Direction.Axis, VoxelShape> allAxis(VoxelShape facingY) {
        EnumMap<Direction.Axis, VoxelShape> map = new EnumMap<Direction.Axis, VoxelShape>(Direction.Axis.class);
        for (Direction.Axis axis : Direction.Axis.values()) {
            Vec3 dir = ShapeUtils.getDirectionRotationVec(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            map.put(axis, ShapeUtils.rotatedCopy(facingY, dir));
        }
        return map;
    }

    public static Map<Direction, VoxelShape> allDirections(VoxelShape facingUp) {
        EnumMap<Direction, VoxelShape> map = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (Direction dir : Direction.values()) {
            map.put(dir, ShapeUtils.rotatedCopy(facingUp, ShapeUtils.getDirectionRotationVec(dir)));
        }
        return map;
    }

    public static VoxelShape rotatedCopy(VoxelShape shape, Vec3 rotation) {
        if (rotation.equals((Object)Vec3.ZERO)) {
            return shape;
        }
        MutableObject result = new MutableObject((Object)Shapes.empty());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v1 = new Vec3(x1, y1, z1).scale(16.0).subtract(center);
            Vec3 v2 = new Vec3(x2, y2, z2).scale(16.0).subtract(center);
            v1 = ShapeUtils.rotateVec(v1, (float)rotation.x, Direction.Axis.X);
            v1 = ShapeUtils.rotateVec(v1, (float)rotation.y, Direction.Axis.Y);
            v1 = ShapeUtils.rotateVec(v1, (float)rotation.z, Direction.Axis.Z).add(center);
            v2 = ShapeUtils.rotateVec(v2, (float)rotation.x, Direction.Axis.X);
            v2 = ShapeUtils.rotateVec(v2, (float)rotation.y, Direction.Axis.Y);
            v2 = ShapeUtils.rotateVec(v2, (float)rotation.z, Direction.Axis.Z).add(center);
            VoxelShape rotated = Block.box((double)Math.min(v1.x, v2.x), (double)Math.min(v1.y, v2.y), (double)Math.min(v1.z, v2.z), (double)Math.max(v1.x, v2.x), (double)Math.max(v1.y, v2.y), (double)Math.max(v1.z, v2.z));
            result.setValue((Object)Shapes.or((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    public static Vec3 rotateVec(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.ZERO) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.sin((float)angle);
        double cos = Mth.cos((float)angle);
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static double length(VoxelShape shape, Direction.Axis axis) {
        return shape.isEmpty() ? 0.0 : shape.max(axis) - shape.min(axis);
    }

    private static Vec3 getDirectionRotationVec(Direction direction) {
        return direction == Direction.UP ? Vec3.ZERO : new Vec3(Direction.Plane.VERTICAL.test(direction) ? 180.0 : 90.0, (double)(-((float)(Math.max(direction.get2DDataValue(), 0) & 3) * 90.0f)), 0.0);
    }
}

