/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.utils;

import corundum.rubinated_nether.utils.TickableBlockEntity;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface BEBlock<BE extends BlockEntity>
extends EntityBlock {
    public BlockEntityType<? extends BE> getBlockEntityType();

    public Class<? extends BE> getBlockEntityClass();

    @Nullable
    default public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.getBlockEntityType().create(pos, state);
    }

    @Nullable
    default public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (Arrays.asList(this.getBlockEntityClass().getInterfaces()).contains(TickableBlockEntity.class)) {
            return (beLevel, blockPos, blockState, blockEntity) -> {
                if (!blockEntity.hasLevel()) {
                    blockEntity.setLevel(beLevel);
                }
                ((TickableBlockEntity)blockEntity).tick(beLevel.isClientSide);
            };
        }
        return super.getTicker(level, state, blockEntityType);
    }

    @Nullable
    default public BE getBlockEntity(BlockGetter access, BlockPos pos) {
        BlockEntity blockEntity = access.getBlockEntity(pos);
        Class<BE> expectedClass = this.getBlockEntityClass();
        if (!expectedClass.isInstance(blockEntity) || blockEntity.getType() != this.getBlockEntityType()) {
            return null;
        }
        return (BE)blockEntity;
    }
}

