/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.mixin;

import corundum.rubinated_nether.content.enchantment.RNEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class RavagingCurseMixin {
    private boolean suppressDrops = false;

    protected abstract void dropAllDeathLoot(DamageSource var1);

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void checkRavagingCurse(DamageSource damageSource, CallbackInfo ci) {
        LivingEntity killer;
        ItemStack mainHandItem;
        LivingEntity thisEntity = (LivingEntity)this;
        this.suppressDrops = false;
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity && !(mainHandItem = (killer = (LivingEntity)entity).getMainHandItem()).isEmpty()) {
            try {
                Holder.Reference antiLootingCurse = thisEntity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(RNEnchantments.RAVAGING_CURSE);
                int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)antiLootingCurse, (ItemStack)mainHandItem);
                if (enchantmentLevel > 0 && thisEntity.level().getRandom().nextFloat() < 0.5f) {
                    this.suppressDrops = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    private void suppressDropsIfNeeded(ServerLevel p_level, DamageSource damageSource, CallbackInfo ci) {
        if (this.suppressDrops) {
            ci.cancel();
        }
    }
}

