/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.mixin;

import corundum.rubinated_nether.utils.BlockUpdateListener;
import corundum.rubinated_nether.utils.UpdateListenerHolder;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements UpdateListenerHolder {
    @Unique
    private final Long2ReferenceMap<Set<BlockUpdateListener>> rubinatedNether$updateListeners = new Long2ReferenceOpenHashMap();

    @Shadow
    public abstract BlockState getBlockState(BlockPos var1);

    @Override
    public void rubinatedNether$addUpdateListener(BlockUpdateListener listener) {
        listener.getListenedPositions().mapToLong(BlockPos::asLong).forEach(l -> ((Set)this.rubinatedNether$updateListeners.computeIfAbsent(l, $ -> new ObjectArraySet())).add(listener));
    }

    @Override
    public void rubinatedNether$handleBlockUpdate(BlockPos pos) {
        long longPos = pos.asLong();
        Set listeners = (Set)this.rubinatedNether$updateListeners.get(longPos);
        if (listeners != null) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                BlockUpdateListener listener = (BlockUpdateListener)iterator.next();
                if (listener.shouldRemove()) {
                    iterator.remove();
                    continue;
                }
                listener.handleBlockUpdate((Level)this, pos, this.getBlockState(pos));
            }
            if (listeners.isEmpty()) {
                this.rubinatedNether$updateListeners.remove(longPos);
            }
        }
    }
}

