/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.mixin;

import corundum.rubinated_nether.content.enchantment.RNEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class ExposureCurseMixin {
    @Inject(method={"getArmorValue"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyArmorValue(CallbackInfoReturnable<Integer> cir) {
        LivingEntity entity = (LivingEntity)this;
        Holder.Reference exposureCurse = entity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(RNEnchantments.EXPOSURE_CURSE);
        int totalModifiedArmor = 0;
        boolean anyCursed = false;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            Item item;
            ItemStack armorPiece = entity.getItemBySlot(slot);
            if (armorPiece.isEmpty() || !((item = armorPiece.getItem()) instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            int baseArmorValue = armorItem.getDefense();
            int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)exposureCurse, (ItemStack)armorPiece);
            if (enchantmentLevel > 0) {
                int modifiedArmor = Math.max(1, (int)Math.floor((double)baseArmorValue * 0.5));
                totalModifiedArmor += modifiedArmor;
                anyCursed = true;
                continue;
            }
            totalModifiedArmor += baseArmorValue;
        }
        if (anyCursed) {
            cir.setReturnValue((Object)totalModifiedArmor);
        }
    }
}

