/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.events;

import com.mojang.logging.LogUtils;
import corundum.rubinated_nether.content.blocks.entities.FreezerBlockEntity;
import corundum.rubinated_nether.content.items.DrillItem;
import corundum.rubinated_nether.content.recipe.fuel.FreezerFuel;
import corundum.rubinated_nether.misc.DatapackRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="rubinated_nether")
public class RNGameBusEvents {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, Long> lastMiningTick = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> decayTicks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastLoggedTick = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        Item item;
        Player player = event.getEntity();
        ItemStack itemStack = player.getMainHandItem();
        if (!event.isCanceled() && (item = itemStack.getItem()) instanceof DrillItem) {
            DrillItem drillItem = (DrillItem)item;
            long currentTick = player.level().getGameTime();
            UUID playerId = player.getUUID();
            lastMiningTick.put(playerId, currentTick);
            CompoundTag tag = drillItem.getNBT();
            int ticksUsed = tag.getInt("ticksUsed");
            float multiplier = 1.0f + (float)ticksUsed / (float)DrillItem.MAX_USE_TICKS * ((float)DrillItem.MAX_MULTIPLIER_BOOST - 1.0f);
            if (ticksUsed < DrillItem.MAX_USE_TICKS) {
                tag.putInt("ticksUsed", ticksUsed + 1);
            }
            event.setNewSpeed(event.getNewSpeed() * multiplier);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        UUID playerId = player.getUUID();
        long currentTick = player.level().getGameTime();
        Item item = stack.getItem();
        if (item instanceof DrillItem) {
            DrillItem drill = (DrillItem)item;
            CompoundTag tag = drill.getNBT();
            if (tag == null) {
                return;
            }
            if (!lastLoggedTick.containsKey(playerId) || currentTick - lastLoggedTick.get(playerId) >= 40L) {
                int ticksUsed = tag.getInt("ticksUsed");
                float multiplier = 1.0f + (float)ticksUsed / (float)DrillItem.MAX_USE_TICKS * ((float)DrillItem.MAX_MULTIPLIER_BOOST - 1.0f);
                player.sendSystemMessage((Component)Component.literal((String)("Current Drill Speed Multiplier: " + multiplier)));
                lastLoggedTick.put(playerId, currentTick);
            }
            if (!lastMiningTick.containsKey(playerId)) {
                return;
            }
            Long lastTick = lastMiningTick.get(playerId);
            if (currentTick - lastTick <= 20L) {
                return;
            }
            if (!decayTicks.containsKey(playerId)) {
                decayTicks.put(playerId, 0);
            }
            int decayCount = decayTicks.get(playerId);
            if (currentTick % 20L != 0L) {
                return;
            }
            int ticksUsed = tag.getInt("ticksUsed");
            if (ticksUsed > 0) {
                int reduction = (int)Math.ceil((double)ticksUsed * 0.25);
                tag.putInt("ticksUsed", Math.max(ticksUsed - reduction, 0));
            } else {
                lastMiningTick.remove(playerId);
                decayTicks.remove(playerId);
            }
            decayTicks.put(playerId, decayCount + 1);
        }
    }

    @SubscribeEvent
    public static void freezerFuel(ServerAboutToStartEvent event) {
        FreezerBlockEntity.cleanFreezingTimes();
        Set entries = event.getServer().registryAccess().registryOrThrow(DatapackRegistry.FREEZER_FUELS).entrySet();
        LOGGER.info("Registered Freezer Fuels: {}", (Object)entries.size());
        for (Map.Entry entry : entries) {
            FreezerFuel x = (FreezerFuel)entry.getValue();
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)x.item()));
            LOGGER.info(x.toString());
            FreezerBlockEntity.addItemFreezingTime((ItemLike)item, x.freezeTime());
        }
    }
}

