/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.data.registries;

import com.google.common.collect.ImmutableList;
import corundum.rubinated_nether.data.registries.RNConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class RNPlacedFeatures {
    public static final ResourceKey<PlacedFeature> MOLTEN_RUBY_ORE = RNPlacedFeatures.createKey("molten_ruby_ore");

    public static void bootstap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(MOLTEN_RUBY_ORE, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(RNConfiguredFeatures.MOLTEN_RUBY_ORE), RNPlacedFeatures.orePlacement(50, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)40)))));
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rubinated_nether", (String)name));
    }

    public static List<PlacementModifier> orePlacement(int count, PlacementModifier heightRange) {
        return ImmutableList.builder().add((Object)heightRange).add((Object)CountPlacement.of((int)count)).add((Object)InSquarePlacement.spread()).add((Object)BiomeFilter.biome()).build();
    }
}

