/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.data;

import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.blocks.SixWayPillarBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.apache.commons.lang3.function.TriConsumer;

public class RNBlockStates
extends BlockStateProvider {
    public RNBlockStates(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "rubinated_nether", fileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)RNBlocks.NETHER_RUBY_ORE.get());
        this.simpleBlock((Block)RNBlocks.MOLTEN_RUBY_ORE.get());
        this.simpleBlock((Block)RNBlocks.RUBINATED_BLACKSTONE.get());
        this.simpleBlock((Block)RNBlocks.RUBY_BLOCK.get());
        this.axisBlock((RotatedPillarBlock)RNBlocks.MOLTEN_RUBY_BLOCK.get());
        this.simpleBlock((Block)RNBlocks.BLEEDING_OBSIDIAN.get());
        this.simpleBlock((Block)RNBlocks.BRAZIER.get(), (ModelFile)this.models().withExistingParent("ruby_brazier", this.modLoc("block/ruby_brazier_base")));
        this.simpleBlock((Block)RNBlocks.RUBINATION_ALTAR.get(), (ModelFile)this.models().withExistingParent("rubination_altar", this.modLoc("block/rubination_altar_base")));
        this.lantern((Block)RNBlocks.RUBY_LANTERN.get(), "ruby_lantern");
        this.simpleBlock((Block)RNBlocks.CHANDELIER.get(), (ModelFile)this.models().withExistingParent("ruby_chandelier", this.modLoc("block/ruby_chandelier_base")));
        this.axisBlock((RotatedPillarBlock)RNBlocks.LAVA_LAMP.get(), (ModelFile)this.models().withExistingParent("lava_lamp", this.modLoc("block/lava_lamp_side_base")), (ModelFile)this.models().withExistingParent("lava_lamp", this.modLoc("block/lava_lamp_base")));
        this.simpleBlock((Block)RNBlocks.DRY_ICE.get(), (ModelFile)this.models().withExistingParent("dry_ice", this.modLoc("block/dry_ice_base")));
        this.simpleBlock((Block)RNBlocks.SOAKSTONE.get());
        this.glassWithPane((Block)RNBlocks.RUBY_GLASS.get(), (IronBarsBlock)RNBlocks.RUBY_GLASS_PANE.get(), "ruby_glass", this.modLoc("block/ruby_glass_pane_top"));
        this.glassWithPane((Block)RNBlocks.ORNATE_RUBY_GLASS.get(), (IronBarsBlock)RNBlocks.ORNATE_RUBY_GLASS_PANE.get(), "ornate_ruby_glass", this.modLoc("block/ornate_ruby_glass_pane_top"));
        this.glassWithPane((Block)RNBlocks.MOLTEN_RUBY_GLASS.get(), (IronBarsBlock)RNBlocks.MOLTEN_RUBY_GLASS_PANE.get(), "molten_ruby_glass", this.modLoc("block/molten_ruby_glass_pane_top"));
        this.simpleBlock((Block)RNBlocks.SHRINE_STONE.get());
        this.simpleBlock((Block)RNBlocks.POLISHED_SHRINE_STONE.get());
        this.slabBlock((SlabBlock)RNBlocks.POLISHED_SHRINE_STONE_SLAB.get(), this.modLoc("block/polished_shrine_stone"), this.modLoc("block/polished_shrine_stone"));
        this.stairsBlock((StairBlock)RNBlocks.POLISHED_SHRINE_STONE_STAIRS.get(), this.modLoc("block/polished_shrine_stone"));
        this.wallBlock((WallBlock)RNBlocks.POLISHED_SHRINE_STONE_WALL.get(), this.modLoc("block/polished_shrine_stone"));
        this.simpleBlock((Block)RNBlocks.SHRINE_STONE_TILES.get());
        this.slabBlock((SlabBlock)RNBlocks.SHRINE_STONE_TILES_SLAB.get(), this.modLoc("block/shrine_stone_tiles"), this.modLoc("block/shrine_stone_tiles"));
        this.stairsBlock((StairBlock)RNBlocks.SHRINE_STONE_TILES_STAIRS.get(), this.modLoc("block/shrine_stone_tiles"));
        this.wallBlock((WallBlock)RNBlocks.SHRINE_STONE_TILES_WALL.get(), this.modLoc("block/shrine_stone_tiles"));
        this.axisBlock((RotatedPillarBlock)RNBlocks.SHRINE_STONE_PILLAR.get());
        this.simpleBlock((Block)RNBlocks.SHRINE_STONE_BRICKS.get());
        this.slabBlock((SlabBlock)RNBlocks.SHRINE_STONE_BRICKS_SLAB.get(), this.modLoc("block/shrine_stone_bricks"), this.modLoc("block/shrine_stone_bricks"));
        this.stairsBlock((StairBlock)RNBlocks.SHRINE_STONE_BRICKS_STAIRS.get(), this.modLoc("block/shrine_stone_bricks"));
        this.wallBlock((WallBlock)RNBlocks.SHRINE_STONE_BRICKS_WALL.get(), this.modLoc("block/shrine_stone_bricks"));
        this.simpleBlock((Block)RNBlocks.CHISELED_SHRINE_STONE_BRICKS.get());
        this.simpleBlock((Block)RNBlocks.RUBINATED_SHRINE_STONE_BRICKS.get());
        this.sixWayPillar(RNBlocks.RUBINATED_CHISELED_SHRINE_STONE_BRICKS, this.modLoc("block/" + this.blockName(RNBlocks.RUBINATED_CHISELED_SHRINE_STONE_BRICKS) + "_side"), this.modLoc("block/" + this.blockName(RNBlocks.RUBINATED_CHISELED_SHRINE_STONE_BRICKS) + "_end"));
        this.subfolder("bronze/bronze_block/", RNBlocks.BRONZE_BLOCK, RNBlocks.DISCOLORED_BRONZE_BLOCK, RNBlocks.CORRODED_BRONZE_BLOCK, RNBlocks.TARNISHED_BRONZE_BLOCK, RNBlocks.CRYSTALLIZED_BRONZE_BLOCK);
        this.subfolder("bronze/cut_bronze_pillar/", (rloc, name, block) -> this.sixWayPillar((DeferredBlock<?>)block, this.modLoc(rloc + "_side"), this.modLoc(rloc + "_end")), RNBlocks.CUT_BRONZE_PILLAR, RNBlocks.DISCOLORED_CUT_BRONZE_PILLAR, RNBlocks.CORRODED_CUT_BRONZE_PILLAR, RNBlocks.TARNISHED_CUT_BRONZE_PILLAR, RNBlocks.CRYSTALLIZED_CUT_BRONZE_PILLAR);
        this.subfolder("bronze/cut_bronze_bricks/", RNBlocks.CUT_BRONZE_BRICKS, RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS, RNBlocks.CORRODED_CUT_BRONZE_BRICKS, RNBlocks.TARNISHED_CUT_BRONZE_BRICKS, RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS);
        this.slabBlock((SlabBlock)RNBlocks.CUT_BRONZE_BRICKS_SLAB.get(), this.modLoc("block/cut_bronze_bricks"), this.modLoc("block/bronze/cut_bronze_bricks/cut_bronze_bricks"));
        this.stairsBlock((StairBlock)RNBlocks.CUT_BRONZE_BRICKS_STAIRS.get(), this.modLoc("block/bronze/cut_bronze_bricks/cut_bronze_bricks"));
        this.slabBlock((SlabBlock)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_SLAB.get(), this.modLoc("block/discolored_cut_bronze_bricks"), this.modLoc("block/bronze/cut_bronze_bricks/discolored_cut_bronze_bricks"));
        this.stairsBlock((StairBlock)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_STAIRS.get(), this.modLoc("block/bronze/cut_bronze_bricks/discolored_cut_bronze_bricks"));
        this.slabBlock((SlabBlock)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_SLAB.get(), this.modLoc("block/corroded_cut_bronze_bricks"), this.modLoc("block/bronze/cut_bronze_bricks/corroded_cut_bronze_bricks"));
        this.stairsBlock((StairBlock)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_STAIRS.get(), this.modLoc("block/bronze/cut_bronze_bricks/corroded_cut_bronze_bricks"));
        this.slabBlock((SlabBlock)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS_SLAB.get(), this.modLoc("block/tarnished_cut_bronze_bricks"), this.modLoc("block/bronze/cut_bronze_bricks/tarnished_cut_bronze_bricks"));
        this.stairsBlock((StairBlock)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS_STAIRS.get(), this.modLoc("block/bronze/cut_bronze_bricks/tarnished_cut_bronze_bricks"));
        this.slabBlock((SlabBlock)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_SLAB.get(), this.modLoc("block/crystallized_cut_bronze_bricks"), this.modLoc("block/bronze/cut_bronze_bricks/crystallized_cut_bronze_bricks"));
        this.stairsBlock((StairBlock)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_STAIRS.get(), this.modLoc("block/bronze/cut_bronze_bricks/crystallized_cut_bronze_bricks"));
    }

    private void glassWithPane(Block glass, IronBarsBlock pane, String name, ResourceLocation edge) {
        this.simpleBlock(glass, (ModelFile)((BlockModelBuilder)this.models().cubeAll(name, this.modLoc("block/" + name))).renderType(this.mcLoc("translucent")));
        this.paneBlockWithRenderType(pane, this.modLoc("block/" + name), edge, this.mcLoc("translucent"));
    }

    public void sixWayPillar(DeferredBlock<?> block, ResourceLocation side, ResourceLocation end) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName(block), this.mcLoc("block/cube_column"))).texture("side", side)).texture("end", end));
            ConfiguredModel.Builder builder2 = builder.rotationX(switch ((Direction)state.getValue(SixWayPillarBlock.FACING)) {
                case Direction.UP -> 0;
                case Direction.DOWN -> 180;
                default -> 90;
            });
            return builder2.rotationY(switch ((Direction)state.getValue(SixWayPillarBlock.FACING)) {
                case Direction.NORTH -> 0;
                case Direction.SOUTH -> 180;
                case Direction.EAST -> 90;
                case Direction.WEST -> 270;
                default -> 0;
            }).build();
        });
    }

    public void lantern(Block lamp, String name) {
        String location = "block/" + name;
        BlockModelBuilder lantern = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("template_lantern"))).texture("lantern", this.modLoc(location))).renderType(this.mcLoc("cutout"));
        BlockModelBuilder hangingLantern = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("hanging_" + name, this.mcLoc("template_hanging_lantern"))).texture("lantern", this.modLoc(location))).renderType(this.mcLoc("cutout"));
        this.getVariantBuilder(lamp).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.getValue((Property)LanternBlock.HANGING) != false ? hangingLantern : lantern)).build());
    }

    public void subfolder(String folder, DeferredBlock<?> ... blocks) {
        for (DeferredBlock<?> block : blocks) {
            String name = this.blockName(block);
            this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeAll(name, this.modLoc("block/" + folder + name)));
        }
    }

    public void subfolder(String folder, TriConsumer<String, String, DeferredBlock<?>> fn, DeferredBlock<?> ... blocks) {
        for (DeferredBlock<?> block : blocks) {
            String name = this.blockName(block);
            fn.accept((Object)("block/" + folder + name), (Object)name, block);
        }
    }

    private String blockName(DeferredBlock<?> block) {
        return block.getId().toString().split(":")[1];
    }
}

