/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.recipe.JEI;

import corundum.rubinated_nether.RubinatedNether;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.recipe.FreezingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class FreezerRecipeCategory
implements IRecipeCategory<FreezingRecipe> {
    public static final ResourceLocation UID = RubinatedNether.id("freezing");
    public static final ResourceLocation TEXTURE = RubinatedNether.id("textures/gui/freezer_gui.png");
    public static final RecipeType<FreezingRecipe> RECIPE_TYPE = new RecipeType(UID, FreezingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable fuelIndicator;
    private final IDrawableAnimated animatedProgressArrow;

    public FreezerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 55, 16, 82, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((Block)RNBlocks.FREEZER.get()).asItem()));
        this.fuelIndicator = helper.createDrawable(TEXTURE, 176, 0, 14, 13);
        this.animatedProgressArrow = helper.createAnimatedDrawable(helper.createDrawable(TEXTURE, 176, 14, 23, 16), 100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<FreezingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.rubinated_nether.jei.freezer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FreezingRecipe freezingRecipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)freezingRecipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(freezingRecipe.getResult());
    }

    public void draw(FreezingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedProgressArrow.draw(guiGraphics, 24, 18);
        this.fuelIndicator.draw(guiGraphics, 1, 20);
        this.drawExperience(recipe, guiGraphics, 1, this.background);
        this.drawCookingTime(guiGraphics, 45, recipe.getCookingTime(), this.background);
    }

    protected void drawExperience(FreezingRecipe recipe, GuiGraphics guiGraphics, int y, IDrawable background) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Font fontRenderer = Minecraft.getInstance().font;
            int stringWidth = fontRenderer.width((FormattedText)experienceString);
            guiGraphics.drawString(fontRenderer, (Component)experienceString, background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookingTime(GuiGraphics guiGraphics, int y, int time, IDrawable background) {
        if (time > 0) {
            int cookTimeSeconds = time / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font fontRenderer = Minecraft.getInstance().font;
            int stringWidth = fontRenderer.width((FormattedText)timeString);
            guiGraphics.drawString(fontRenderer, (Component)timeString, background.getWidth() - stringWidth, y, -8355712, false);
        }
    }
}

