/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.menu;

import com.mojang.datafixers.util.Pair;
import corundum.rubinated_nether.RubinatedNether;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.RNItems;
import corundum.rubinated_nether.content.RNTags;
import corundum.rubinated_nether.content.blocks.RubinationAltarBlock;
import corundum.rubinated_nether.content.items.Rubination;
import corundum.rubinated_nether.content.items.RuneItem;
import corundum.rubinated_nether.content.menu.RNMenuTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.CommonHooks;

public class RubinationMenu
extends AbstractContainerMenu {
    static final ResourceLocation EMPTY_SLOT_RUBIES = RubinatedNether.id("item/empty_slot_ruby");
    private final Container rubinationSlots;
    private final ContainerLevelAccess access;
    public final int[][] rubinationClue;
    public final Set<RuneItem> runes = new HashSet<RuneItem>();
    private int axeCycle = 0;
    private boolean hadAxeInSlot = false;

    public RubinationMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public RubinationMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)RNMenuTypes.RUBINATION_MENU.get(), containerId);
        this.rubinationSlots = new SimpleContainer(2){

            public void setChanged() {
                super.setChanged();
                RubinationMenu.this.slotsChanged((Container)this);
            }
        };
        this.rubinationClue = new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}};
        this.access = access;
        this.addSlot(new Slot(this, this.rubinationSlots, 0, 70, 84){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.rubinationSlots, 1, 90, 84){

            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.is((Item)RNItems.RUBY_ITEM.get());
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_SLOT_RUBIES);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 113 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 171));
        }
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[0], (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[1], (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[2], (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[0], (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[1], (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[2], (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[0], (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[1], (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.rubinationClue[2], (int)2));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0) {
            ItemStack itemstack = this.rubinationSlots.getItem(0);
            ItemStack itemstack1 = this.rubinationSlots.getItem(1);
            int rubyCost = 1;
            if (itemstack1.isEmpty() || itemstack1.getCount() < rubyCost) {
                return false;
            }
            if (!itemstack.isEmpty()) {
                this.access.execute((level, blockPos) -> {
                    List<Rubination> arrayList = this.getRubinationMap(itemstack, this.runes);
                    List<EnchantmentInstance> selectedEnchantments = this.getSelectedEnchants(level.registryAccess(), arrayList, id);
                    if (!arrayList.isEmpty() && selectedEnchantments != null) {
                        ItemStack itemstack2 = itemstack.getItem().applyEnchantments(itemstack, selectedEnchantments);
                        this.rubinationSlots.setItem(0, itemstack2);
                        CommonHooks.onPlayerEnchantItem((Player)player, (ItemStack)itemstack2, selectedEnchantments);
                        itemstack1.consume(rubyCost, (LivingEntity)player);
                        if (itemstack1.isEmpty()) {
                            this.rubinationSlots.setItem(1, ItemStack.EMPTY);
                        }
                        player.awardStat(Stats.ENCHANT_ITEM);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.ENCHANTED_ITEM.trigger((ServerPlayer)player, itemstack2, rubyCost);
                        }
                        this.rubinationSlots.setChanged();
                        this.slotsChanged(this.rubinationSlots);
                        level.playSound(null, blockPos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                    }
                });
                return true;
            }
            return false;
        }
        String var10000 = String.valueOf(player.getName());
        Util.logAndPauseIfInIde((String)(var10000 + " pressed invalid button id: " + id));
        return false;
    }

    private List<Rubination> getRubinationMap(ItemStack stack, Set<RuneItem> runes) {
        ArrayList<Rubination> arrayList = new ArrayList<Rubination>(3);
        if (stack.is(RNTags.Items.AXES)) {
            boolean showToolsOnly;
            ArrayList<Rubination> toolRubinations = new ArrayList<Rubination>();
            ArrayList<Rubination> weaponRubinations = new ArrayList<Rubination>();
            for (RuneItem rune : runes) {
                Rubination rubination = rune.getRubination();
                if (!stack.is(rubination.getItemTag())) continue;
                if (rubination.getItemTag().equals(RNTags.Items.RUBINATION_TOOL)) {
                    toolRubinations.add(rubination);
                    continue;
                }
                if (!rubination.getItemTag().equals(RNTags.Items.RUBINATION_WEAPON)) continue;
                weaponRubinations.add(rubination);
            }
            boolean bl = showToolsOnly = this.axeCycle % 2 == 0;
            if (showToolsOnly) {
                arrayList.addAll(toolRubinations);
            } else {
                arrayList.addAll(weaponRubinations);
            }
        } else {
            for (RuneItem rune : runes) {
                if (!stack.is(rune.getRubination().getItemTag())) continue;
                arrayList.add(rune.getRubination());
            }
        }
        return arrayList;
    }

    public void slotsChanged(Container inventory) {
        if (inventory == this.rubinationSlots) {
            boolean currentlyHasAxe;
            ItemStack itemstack = inventory.getItem(0);
            boolean bl = currentlyHasAxe = !itemstack.isEmpty() && itemstack.is(RNTags.Items.AXES);
            if (currentlyHasAxe && !this.hadAxeInSlot) {
                ++this.axeCycle;
                this.hadAxeInSlot = true;
            } else if (!currentlyHasAxe && this.hadAxeInSlot) {
                this.hadAxeInSlot = false;
            } else if (!itemstack.isEmpty() && !currentlyHasAxe) {
                this.axeCycle = 0;
                this.hadAxeInSlot = false;
            }
            if (!itemstack.isEmpty() && itemstack.isEnchantable()) {
                this.access.execute((level, blockPos) -> {
                    IdMap idmap = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    for (BlockPos blockpos : RubinationAltarBlock.RUNESTONE_OFFSETS) {
                        Item patt0$temp;
                        if (!RubinationAltarBlock.isValidCatalyst(level, blockPos, blockpos) || !((patt0$temp = RubinationAltarBlock.getRuneFromCatalyst(level, blockPos, blockpos)) instanceof RuneItem)) continue;
                        RuneItem runeItem = (RuneItem)patt0$temp;
                        this.runes.add(runeItem);
                    }
                    for (int k = 0; k < 3; ++k) {
                        for (int i = 0; i < 3; ++i) {
                            this.rubinationClue[k][i] = -1;
                        }
                    }
                    List<Rubination> arrayList = this.getRubinationMap(itemstack, this.runes);
                    for (int l = 0; l < 3; ++l) {
                        for (int c = 0; c < 3; ++c) {
                            if (arrayList == null || arrayList.isEmpty()) continue;
                            List<EnchantmentInstance> list = this.getSelectedEnchants(level.registryAccess(), arrayList, l);
                            if (list != null && c < list.size()) {
                                EnchantmentInstance enchantmentinstance = list.get(c);
                                this.rubinationClue[l][c] = idmap.getId((Object)enchantmentinstance.enchantment);
                                continue;
                            }
                            this.rubinationClue[l][c] = -1;
                        }
                    }
                    this.broadcastChanges();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    for (int k = 0; k < 3; ++k) {
                        this.rubinationClue[i][k] = -1;
                    }
                }
            }
        }
    }

    private List<EnchantmentInstance> getSelectedEnchants(RegistryAccess registryAccess, List<Rubination> arrayList, int id) {
        if (arrayList.isEmpty() || id >= arrayList.size()) {
            return null;
        }
        return arrayList.get(id).getEnchantments(registryAccess);
    }

    public int getRubyCount() {
        ItemStack itemstack = this.rubinationSlots.getItem(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    public ItemStack getItemInSlot() {
        ItemStack itemstack = this.rubinationSlots.getItem(0);
        return itemstack.isEmpty() ? ItemStack.EMPTY : itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.axeCycle = 0;
        this.hadAxeInSlot = false;
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.rubinationSlots));
    }

    public boolean stillValid(Player player) {
        return RubinationMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)RNBlocks.RUBINATION_ALTAR.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.is((Item)RNItems.RUBY_ITEM.get())) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.slots.get(0)).hasItem() || !((Slot)this.slots.get(0)).mayPlace(itemstack1)) {
                    return ItemStack.EMPTY;
                }
                ItemStack itemstack2 = itemstack1.copyWithCount(1);
                itemstack1.shrink(1);
                ((Slot)this.slots.get(0)).setByPlayer(itemstack2);
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

