/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.menu;

import corundum.rubinated_nether.content.RNRecipes;
import corundum.rubinated_nether.content.blocks.entities.FreezerBlockEntity;
import corundum.rubinated_nether.content.menu.FreezerFuelSlot;
import corundum.rubinated_nether.content.menu.RNMenuTypes;
import corundum.rubinated_nether.content.recipe.FreezerServerPlaceRecipe;
import corundum.rubinated_nether.content.recipe.FreezingRecipe;
import corundum.rubinated_nether.content.recipe.RNRecipeBookTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class FreezerMenu
extends RecipeBookMenu<SingleRecipeInput, FreezingRecipe> {
    private final Container container;
    private final ContainerData data;
    protected final Level level;
    private final RecipeType<? extends FreezingRecipe> recipeType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlacement(boolean flag, RecipeHolder<?> holder, ServerPlayer serverPlayer) {
        this.beginPlacingRecipe();
        try {
            new FreezerServerPlaceRecipe(this).recipeClicked(serverPlayer, holder, flag);
        }
        finally {
            this.finishPlacingRecipe(holder);
        }
    }

    public FreezerMenu(int containerId, Inventory playerInventory) {
        this((MenuType)RNMenuTypes.FREEZER_MENU.get(), (RecipeType<? extends FreezingRecipe>)((RecipeType)RNRecipes.FREEZING.get()), RecipeBookType.FURNACE, containerId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    public FreezerMenu(int containerId, Inventory playerInventory, Container freezerContainer, ContainerData data) {
        this((MenuType)RNMenuTypes.FREEZER_MENU.get(), (RecipeType<? extends FreezingRecipe>)((RecipeType)RNRecipes.FREEZING.get()), RecipeBookType.FURNACE, containerId, playerInventory, freezerContainer, data);
    }

    public FreezerMenu(MenuType<?> menuType, RecipeType<? extends FreezingRecipe> recipeType, RecipeBookType recipeBookType, int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super(menuType, containerId);
        this.recipeType = recipeType;
        FreezerMenu.checkContainerSize((Container)container, (int)3);
        FreezerMenu.checkContainerDataCount((ContainerData)data, (int)4);
        this.container = container;
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new Slot(container, 0, 56, 17));
        this.addSlot(new FreezerFuelSlot(this, container, 1, 56, 53));
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, container, 2, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public boolean hasFuel() {
        return this.data.get(2) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 22;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getScaledFuelProgress() {
        int fuelTime = this.data.get(2);
        int fuelDuration = this.data.get(3);
        int fuelScaleSize = 60;
        return fuelDuration != 0 ? (int)((float)fuelTime / (float)fuelDuration * (float)fuelScaleSize) : 0;
    }

    public boolean isFuel(ItemStack stack) {
        return FreezerBlockEntity.getFreezingMap().containsKey((Object)stack.getItem());
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack1 = slot.getItem();
            itemStack = itemStack1.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(itemStack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack1, itemStack);
            } else if (index != 1 && index != 0 ? (this.canSmelt(itemStack1) ? !this.moveItemStackTo(itemStack1, 0, 1, false) : (this.isFuel(itemStack1) ? !this.moveItemStackTo(itemStack1, 1, 2, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(itemStack1, 30, 39, false) : index >= 30 && index < 39 && !this.moveItemStackTo(itemStack1, 3, 30, false)))) : !this.moveItemStackTo(itemStack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack1);
        }
        return itemStack;
    }

    protected boolean canSmelt(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    public int getBurnProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.get(0) * 13 / i;
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    public RecipeBookType getRecipeBookType() {
        return RNRecipeBookTypes.FREEZER;
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot != 1;
    }

    public void fillCraftSlotsStackedContents(StackedContents contents) {
        Container container = this.container;
        if (container instanceof StackedContentsCompatible) {
            StackedContentsCompatible stackedContentsCompatible = (StackedContentsCompatible)container;
            stackedContentsCompatible.fillStackedContents(contents);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(2).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder recipe) {
        return recipe.value().matches((RecipeInput)new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    public int getResultSlotIndex() {
        return 2;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 3;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

