/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.items;

import corundum.rubinated_nether.content.entity.BronzeShotProjectileEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class BronzeShotItem
extends Item
implements ProjectileItem {
    public BronzeShotItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerProjectileBehavior((ItemLike)this);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.METAL_FALL, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            BronzeShotProjectileEntity bronzeShotProjectile = new BronzeShotProjectileEntity((LivingEntity)player, level);
            bronzeShotProjectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 0.0f);
            level.addFreshEntity((Entity)bronzeShotProjectile);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.isCreative()) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        BronzeShotProjectileEntity proj = new BronzeShotProjectileEntity(level, pos);
        proj.addDeltaMovement(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()));
        proj.pickup = AbstractArrow.Pickup.ALLOWED;
        return proj;
    }
}

