/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import corundum.rubinated_nether.content.entity.BronzeEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BronzeModel<T extends BronzeEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;

    public BronzeModel(ModelPart root) {
        this.root = root.getChild("bronze");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bronze = partdefinition.addOrReplaceChild("bronze", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)24.0f, (float)-4.0f));
        PartDefinition head = bronze.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 12).addBox(-9.0f, -10.0f, -1.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition windup = head.addOrReplaceChild("windup", CubeListBuilder.create().texOffs(39, 14).mirror().addBox(-9.0f, -16.0f, 4.0f, 10.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(49, 24).addBox(-5.0f, -15.0f, 3.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rod1 = bronze.addOrReplaceChild("rod1", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-1.0f, (float)4.0f));
        PartDefinition cube_r1 = rod1.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 38).addBox(1.7189f, -12.2678f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition rod2 = bronze.addOrReplaceChild("rod2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)-2.0944f, (float)0.0f));
        PartDefinition cube_r2 = rod2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(12, 38).addBox(1.7189f, -12.2678f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition rod3 = bronze.addOrReplaceChild("rod3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r3 = rod3.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(12, 38).addBox(1.7189f, -12.2678f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition rod4 = bronze.addOrReplaceChild("rod4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition cube_r4 = rod4.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(12, 38).addBox(1.7189f, -12.2678f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition rod5 = bronze.addOrReplaceChild("rod5", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition cube_r5 = rod5.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(12, 38).addBox(1.7189f, -12.2678f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition rod6 = bronze.addOrReplaceChild("rod6", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)2.0944f, (float)0.0f));
        PartDefinition cube_r6 = rod6.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(12, 38).addBox(1.7189f, -12.2678f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(BronzeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

