/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import corundum.rubinated_nether.content.entity.BronzeShotProjectileEntity;
import corundum.rubinated_nether.content.entity.client.BronzeChargeProjectileModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BronzeChargeProjectileRenderer
extends EntityRenderer<BronzeShotProjectileEntity> {
    private BronzeChargeProjectileModel model;

    public BronzeChargeProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BronzeChargeProjectileModel(context.bakeLayer(BronzeChargeProjectileModel.LAYER_LOCATION));
    }

    public void render(BronzeShotProjectileEntity pEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        if (!pEntity.isGrounded()) {
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)pEntity.yRotO, (float)pEntity.getYRot())));
            poseStack.mulPose(Axis.XP.rotationDegrees(pEntity.getRenderingRotation() * 5.0f));
            poseStack.translate(0.0f, -1.0f, 0.0f);
        } else {
            poseStack.mulPose(Axis.YP.rotationDegrees(pEntity.getYRot()));
            poseStack.mulPose(Axis.XP.rotationDegrees(pEntity.getXRot()));
            poseStack.translate(0.0f, -1.0f, 0.0f);
        }
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(pEntity)), (boolean)false, (boolean)false);
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)pEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(BronzeShotProjectileEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"rubinated_nether", (String)"textures/entity/bronze_shot/bronze_shot.png");
    }
}

