/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.entity;

import com.google.common.collect.ImmutableList;
import corundum.rubinated_nether.content.RNEntityCreator;
import corundum.rubinated_nether.content.RNItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BronzeShotProjectileEntity
extends AbstractArrow {
    private float rotation;
    private ItemStack firedFromWeapon;
    private float weight = 0.05f;
    private boolean hasBounced = false;
    private boolean hasBeenDeflected = false;

    public BronzeShotProjectileEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BronzeShotProjectileEntity(LivingEntity shooter, Level level) {
        super(RNEntityCreator.BRONZE_SHOT.get(), shooter, level, new ItemStack((ItemLike)RNItems.BRONZE_SHOT.get()), null);
    }

    public BronzeShotProjectileEntity(Level level, Position pos) {
        super(RNEntityCreator.BRONZE_SHOT.get(), pos.x(), pos.y(), pos.z(), level, new ItemStack((ItemLike)RNItems.BRONZE_SHOT.get()), null);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)RNItems.BRONZE_SHOT.get());
    }

    public float getRenderingRotation() {
        this.rotation += 2.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public boolean isGrounded() {
        return this.inGround;
    }

    protected void doKnockback(LivingEntity entity, DamageSource damageSource) {
        float f;
        Level level;
        if (this.firedFromWeapon != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)this.firedFromWeapon, (Entity)entity, (DamageSource)damageSource, (float)0.0f);
        } else {
            f = 0.0f;
        }
        double d0 = f;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                entity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.hasBounced && !this.hasBeenDeflected) {
            return;
        }
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)this.getBaseDamage());
        if (!this.hasBeenDeflected) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(-0.001, -0.3, -0.001));
        }
        this.playSound(SoundEvents.ANVIL_PLACE, 1.0f, 1.0f);
        this.hasBounced = true;
        this.weight = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ImmutableList effects = ImmutableList.of((Object)MobEffects.MOVEMENT_SLOWDOWN, (Object)MobEffects.BLINDNESS, (Object)MobEffects.BLINDNESS);
            for (Holder effect : effects) {
                livingEntity.addEffect(new MobEffectInstance(effect, 60, 5, true, false));
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        ItemStack itemstack = this.getWeaponItem();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (itemstack != null) {
                this.hitBlockEnchantmentEffects(serverlevel, result, itemstack);
            }
        }
        this.playSound(SoundEvents.ANVIL_LAND, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setSoundEvent(SoundEvents.ANVIL_LAND);
        if (this.hasBeenDeflected) {
            this.level().levelEvent(2013, BlockPos.containing((Position)this.position()), 750);
            this.discard();
        }
    }

    public void tick() {
        if (!this.hasBeenDeflected && (double)this.weight < 0.2) {
            this.weight += this.weight / 4.0f;
        }
        if (!this.inGround) {
            this.setBaseDamage(this.getBaseDamage() + (double)this.weight);
            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y - (double)(this.weight / 2.0f), this.getDeltaMovement().z);
        }
        super.tick();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public boolean deflect(ProjectileDeflection deflection, Entity entity, Entity owner, boolean deflectedByPlayer) {
        deflection.deflect((Projectile)this, entity, this.random);
        this.setOwner(owner);
        this.hasBeenDeflected = true;
        this.weight = 0.0f;
        for (Entity eType : this.level().getEntities((Entity)this, new AABB(this.position().add(-2.0, -2.0, -2.0), this.position().add(2.0, 2.0, 2.0)))) {
            if (eType.getType() != this.getType()) continue;
            this.playSound(SoundEvents.AMETHYST_BLOCK_BREAK, 10.0f, 1.0f);
            this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.setBaseDamage(this.getBaseDamage() * 10.0);
        }
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("weight", this.weight);
        compound.putBoolean("has_bounced", this.hasBounced);
        compound.putBoolean("has_been_deflected", this.hasBeenDeflected);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("weight")) {
            this.weight = compound.getFloat("weight");
        }
        if (compound.contains("has_bounced")) {
            this.hasBounced = compound.getBoolean("has_bounced");
        }
        if (compound.contains("has_been_deflected")) {
            this.hasBeenDeflected = compound.getBoolean("has_been_deflected");
        }
    }
}

