/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.enchantment.custom;

import corundum.rubinated_nether.content.enchantment.RNEnchantments;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class MisfortuneEventHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        int enchantmentLevel;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack tool = player.getMainHandItem();
        if (tool.isEmpty()) {
            return;
        }
        Registry enchantmentRegistry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Optional misfortuneCurseHolder = enchantmentRegistry.getHolder(RNEnchantments.MISFORTUNE_CURSE);
        if (misfortuneCurseHolder.isPresent() && (enchantmentLevel = tool.getEnchantmentLevel((Holder)misfortuneCurseHolder.get())) > 0 && player.getRandom().nextFloat() < 0.5f) {
            event.setCanceled(true);
            event.getLevel().destroyBlock(event.getPos(), false);
            if (!player.getAbilities().instabuild) {
                tool.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(tool));
            }
        }
    }
}

