/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.enchantment.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record HookingCurseEffect() implements EnchantmentEntityEffect
{
    public static final MapCodec<HookingCurseEffect> CODEC = MapCodec.unit(HookingCurseEffect::new);

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse enchantedItem, Entity target, Vec3 vec3) {
        LivingEntity livingEntity = enchantedItem.owner();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity victim = (LivingEntity)target;
        Vec3 attackerPos = attacker.position();
        Vec3 victimPos = victim.position();
        double dx = victimPos.x - attackerPos.x;
        double dz = victimPos.z - attackerPos.z;
        double knockbackStrength = 1.2;
        this.applyKnockback(victim, knockbackStrength, dx, dz);
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }

    private void applyKnockback(LivingEntity entity, double strength, double x, double z) {
        if ((strength *= 1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)) <= 0.0) {
            return;
        }
        entity.hasImpulse = true;
        Vec3 currentMotion = entity.getDeltaMovement();
        while (x * x + z * z < (double)1.0E-5f) {
            x = (Math.random() - Math.random()) * 0.01;
            z = (Math.random() - Math.random()) * 0.01;
        }
        Vec3 knockbackVector = new Vec3(x, 0.0, z).normalize().scale(strength);
        entity.setDeltaMovement(currentMotion.x / 2.0 - knockbackVector.x, entity.onGround() ? Math.min(0.4, currentMotion.y / 2.0 + strength) : currentMotion.y, currentMotion.z / 2.0 - knockbackVector.z);
    }
}

