/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks.entities;

import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.RNTags;
import corundum.rubinated_nether.content.blocks.RubyLaserBlock;
import corundum.rubinated_nether.mixin.accessors.LevelAccessor;
import corundum.rubinated_nether.utils.BlockUpdateListener;
import corundum.rubinated_nether.utils.ShapeUtils;
import corundum.rubinated_nether.utils.TickableBlockEntity;
import corundum.rubinated_nether.utils.UpdateListenerHolder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.lang3.mutable.MutableDouble;

public class RubyLaserBlockEntity
extends BlockEntity
implements BlockUpdateListener,
TickableBlockEntity {
    private static final Map<Direction, VoxelShape> BEAM_SEGMENT_SHAPES = ShapeUtils.allDirections(Shapes.box((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)1.0, (double)0.6));
    private static final int LASER_RANGE = 15;
    private int powerLevel;
    private int blockRange = -1;
    private int currentRange = 15;
    private double rangeRemnant;
    private boolean visible = false;
    private Optional<Integer> color;
    private boolean silly = false;

    public RubyLaserBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)RNBlockEntities.RUBY_LASER.get(), pos, blockState);
    }

    public void setLevel(Level level) {
        if (!this.hasLevel()) {
            UpdateListenerHolder.addUpdateListener(level, this);
        }
        super.setLevel(level);
    }

    @Override
    public void clientTick() {
        this.handleBlockUpdate(this.level, this.worldPosition, this.getBlockState());
    }

    @Override
    public void tick() {
        this.handleBlockUpdate(this.level, this.worldPosition, this.getBlockState());
        if (((Boolean)this.getBlockState().getValue((Property)RubyLaserBlock.TINTED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)RubyLaserBlock.FACING);
        AABB range = this.getLaserRangeAABB(this.worldPosition, facing);
        AtomicInteger i = new AtomicInteger();
        MutableDouble lastDistance = new MutableDouble((double)this.blockRange);
        ((LevelAccessor)this.level).invokeGetEntities().get(range, entity -> {
            double distance = Math.sqrt(entity.distanceToSqr((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ())) - 1.0;
            if (distance < lastDistance.getValue()) {
                lastDistance.setValue(distance);
                i.set(15 - this.currentRange);
            }
        });
        int blockDistance = Mth.clamp((int)Mth.floor((double)lastDistance.getValue()), (int)0, (int)this.currentRange);
        this.powerLevel = this.currentRange - blockDistance + i.get();
        if (this.powerLevel != (Integer)this.getBlockState().getValue((Property)RubyLaserBlock.POWER)) {
            this.level.scheduleTick(this.getBlockPos(), (Block)RNBlocks.RUBY_LASER.get(), 2);
        }
    }

    @Override
    public void handleBlockUpdate(Level view, BlockPos pos, BlockState bs) {
        this.currentRange = 15;
        Direction facing = (Direction)this.getBlockState().getValue((Property)RubyLaserBlock.FACING);
        BlockPos.MutableBlockPos mutableBlockPos = this.worldPosition.mutable();
        for (int i = 0; i <= 15; ++i) {
            VoxelShape shape;
            mutableBlockPos.move(facing);
            this.blockRange = i;
            BlockState state = this.level.getBlockState((BlockPos)mutableBlockPos);
            boolean blockCheck = state.is(RNTags.Blocks.RUBY_LASER_NO_SIGNAL);
            if (!blockCheck && state.is(RNTags.Blocks.RUBY_LASER_TRANSPARENT) || (shape = Shapes.join((VoxelShape)state.getCollisionShape((BlockGetter)this.level, (BlockPos)mutableBlockPos), (VoxelShape)BEAM_SEGMENT_SHAPES.get(facing), (BooleanOp)BooleanOp.AND)).isEmpty()) continue;
            if (this.level.isClientSide) {
                Direction.Axis axis = facing.getAxis();
                double d = this.rangeRemnant = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? shape.min(axis) : 1.0 - shape.max(axis);
            }
            if (!blockCheck) break;
            this.currentRange = this.blockRange;
            break;
        }
        BlockState state = this.level.getBlockState(this.worldPosition.relative(facing));
        this.silly = state.is(RNTags.Blocks.RAINBOW_LASER);
        boolean bl = this.visible = this.silly || state.is(Tags.Blocks.GLASS_BLOCKS);
        if (this.visible && !this.silly && state.getBlock() instanceof BeaconBeamBlock) {
            DyeColor dye = ((BeaconBeamBlock)state.getBlock()).getColor();
            this.color = Optional.of(dye.getTextureDiffuseColor());
        } else {
            this.color = Optional.empty();
        }
        if (((Boolean)this.getBlockState().getValue((Property)RubyLaserBlock.TINTED)).booleanValue()) {
            this.powerLevel = Mth.clamp((int)(this.currentRange - this.blockRange), (int)0, (int)15);
            if (this.powerLevel != (Integer)this.getBlockState().getValue((Property)RubyLaserBlock.POWER)) {
                this.level.scheduleTick(this.getBlockPos(), (Block)RNBlocks.RUBY_LASER.get(), 2);
            }
        }
    }

    @Override
    public boolean shouldRemove() {
        return this.isRemoved();
    }

    @Override
    public Stream<BlockPos> getListenedPositions() {
        Vec3i offset = ((Direction)this.getBlockState().getValue((Property)RubyLaserBlock.FACING)).getNormal().multiply(15);
        return BlockPos.betweenClosedStream((BlockPos)this.worldPosition, (BlockPos)this.worldPosition.offset(offset));
    }

    public AABB getRenderBoundingBox() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)RubyLaserBlock.FACING);
        Vec3i end = facing.getNormal().multiply(this.currentRange + 1);
        return new AABB(this.worldPosition).expandTowards((double)end.getX(), (double)end.getY(), (double)end.getZ());
    }

    private AABB getLaserRangeAABB(BlockPos worldPosition, Direction facing) {
        Vec3i rangeVec = facing.getNormal().multiply(this.blockRange);
        return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).expandTowards((double)rangeVec.getX(), (double)rangeVec.getY(), (double)rangeVec.getZ()).move(worldPosition.relative(facing));
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public int getBlockRange() {
        return this.blockRange == -1 ? this.currentRange : Mth.clamp((int)this.blockRange, (int)0, (int)this.currentRange);
    }

    public int getCurrentRange() {
        return this.currentRange;
    }

    public double getRenderRange() {
        return (double)this.getBlockRange() + this.rangeRemnant;
    }

    public boolean alwaysVisible() {
        return this.visible;
    }

    public boolean isColored() {
        return this.color.isPresent();
    }

    public boolean isSilly() {
        return this.silly;
    }

    public Optional<Integer> getColor() {
        return this.color;
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)RNBlockEntities.RUBY_LASER.get();
    }
}

