/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks.entities;

import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.RNRecipes;
import corundum.rubinated_nether.content.blocks.entities.AbstractFreezerBlockEntity;
import corundum.rubinated_nether.content.menu.FreezerMenu;
import corundum.rubinated_nether.content.recipe.FreezingRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FreezerBlockEntity
extends AbstractFreezerBlockEntity {
    private static final Object2IntMap<Item> freezingMap = new Object2IntLinkedOpenHashMap();
    private static final Object2IntMap<TagKey<Item>> tagFreezingMap = new Object2IntLinkedOpenHashMap();

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RNBlockEntities.FREEZER.get(), pos, state, (RecipeType<? extends FreezingRecipe>)((RecipeType)RNRecipes.FREEZING.get()));
    }

    public Component getDefaultName() {
        return Component.translatable((String)"menu.rubinated_nether.freezer");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new FreezerMenu(id, playerInventory, (Container)this, this.dataAccess);
    }

    public int getBurnDuration(ItemStack fuelStack) {
        if (fuelStack.isEmpty() || !FreezerBlockEntity.getFreezingMap().containsKey((Object)fuelStack.getItem())) {
            return 0;
        }
        return FreezerBlockEntity.getFreezingMap().getInt((Object)fuelStack.getItem());
    }

    public static Object2IntMap<Item> getFreezingMap() {
        if (tagFreezingMap.isEmpty()) {
            return Object2IntMaps.unmodifiable(freezingMap);
        }
        Object2IntOpenHashMap allItems = new Object2IntOpenHashMap(freezingMap);
        tagFreezingMap.object2IntEntrySet().stream().flatMap(entry -> FreezerBlockEntity.streamTagFuels((TagKey<Item>)((TagKey)entry.getKey()), entry.getIntValue())).forEach(arg_0 -> FreezerBlockEntity.lambda$getFreezingMap$1((Object2IntMap)allItems, arg_0));
        return Object2IntMaps.unmodifiable((Object2IntMap)allItems);
    }

    private static Stream<ObjectIntPair<Item>> streamTagFuels(TagKey<Item> tag, int freezeTime) {
        return BuiltInRegistries.ITEM.getTag(tag).map(set -> set.stream().map(h -> ObjectIntPair.of((Object)((Item)h.value()), (int)freezeTime))).orElseGet(Stream::empty);
    }

    public static void addItemFreezingTime(ItemLike itemProvider, int burnTime) {
        Item item = itemProvider.asItem();
        freezingMap.put((Object)item, burnTime);
    }

    public static void addItemsFreezingTime(ItemLike[] itemProviders, int burnTime) {
        Stream.of(itemProviders).map(ItemLike::asItem).forEach(item -> freezingMap.put(item, burnTime));
    }

    public static void addItemTagFreezingTime(TagKey<Item> itemTag, int burnTime) {
        tagFreezingMap.put(itemTag, burnTime);
    }

    public static void cleanFreezingTimes() {
        freezingMap.clear();
        tagFreezingMap.clear();
    }

    public static void removeItemFreezingTime(ItemLike itemProvider) {
        Item item = itemProvider.asItem();
        freezingMap.removeInt((Object)item);
    }

    public static void removeItemsFreezingTime(ItemLike[] itemProviders) {
        Stream.of(itemProviders).map(ItemLike::asItem).forEach(arg_0 -> freezingMap.removeInt(arg_0));
    }

    public static void removeItemTagFreezingTime(TagKey<Item> itemTag) {
        tagFreezingMap.removeInt(itemTag);
    }

    private static /* synthetic */ void lambda$getFreezingMap$1(Object2IntMap allItems, ObjectIntPair pair) {
        allItems.put((Object)((Item)pair.key()), pair.valueInt());
    }
}

