/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks.entities;

import corundum.rubinated_nether.content.RNBlockEntities;
import corundum.rubinated_nether.content.RNParticleTypes;
import corundum.rubinated_nether.utils.RNConfig;
import corundum.rubinated_nether.utils.TickableBlockEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BrazierBlockEntity
extends BlockEntity
implements TickableBlockEntity {
    public BrazierBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)RNBlockEntities.BRAZIER.get(), pos, blockState);
    }

    @Override
    public void tick() {
        if (this.level == null || this.level.getGameTime() % 40L != 0L) {
            return;
        }
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        AABB area = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).inflate((double)RNConfig.brazierEffectRange);
        Predicate selector = EntitySelector.withinDistance((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)RNConfig.brazierEffectRange).and(EntitySelector.NO_SPECTATORS);
        for (ServerPlayer player : this.level.getEntitiesOfClass(ServerPlayer.class, area, selector)) {
            player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, Mth.floor((float)(20.0f * RNConfig.brazierEffectDuration)), 0, true, RNConfig.brazierEffectParticles, true));
        }
    }

    @Override
    public void clientTick() {
        if (this.level == null || RNConfig.brazierParticleCount == 0) {
            return;
        }
        RandomSource random = this.level.random;
        int xPos = this.worldPosition.getX();
        int yPos = this.worldPosition.getY();
        int zPos = this.worldPosition.getZ();
        for (int i = 0; i < RNConfig.brazierParticleCount; ++i) {
            double x = Mth.clamp((double)((double)xPos + random.nextGaussian() / 6.0), (double)((double)xPos - 0.4), (double)((double)xPos + 0.4));
            double z = Mth.clamp((double)((double)zPos + random.nextGaussian() / 6.0), (double)((double)zPos - 0.4), (double)((double)zPos + 0.4));
            this.level.addParticle((ParticleOptions)RNParticleTypes.RUBY_AURA.get(), x + 0.5, (double)yPos + 0.5, z + 0.5, 0.0, 0.02, 0.0);
        }
    }
}

