/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corundum.rubinated_nether.RubinatedNether;
import corundum.rubinated_nether.content.RNTags;
import corundum.rubinated_nether.content.blocks.TarnishingBronze;
import corundum.rubinated_nether.content.items.WaxableBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TarnishingBronzeStairBlock
extends StairBlock
implements TarnishingBronze {
    public static final MapCodec<TarnishingBronzeStairBlock> CODEC = RecordCodecBuilder.mapCodec(blockInstance -> blockInstance.group((App)TarnishingBronze.TarnishState.CODEC.fieldOf("tarnishing_state").forGetter(ChangeOverTimeBlock::getAge), (App)BlockState.CODEC.fieldOf("base_state").forGetter(stairBlock -> stairBlock.baseState), (App)TarnishingBronzeStairBlock.propertiesCodec()).apply((Applicative)blockInstance, TarnishingBronzeStairBlock::new));
    private final TarnishingBronze.TarnishState tarnishState;

    public MapCodec<TarnishingBronzeStairBlock> codec() {
        return CODEC;
    }

    public TarnishingBronzeStairBlock(TarnishingBronze.TarnishState tarnishState, BlockState state, BlockBehaviour.Properties properties) {
        super(state, properties);
        this.tarnishState = tarnishState;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WAXED});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)WAXED)).booleanValue()) {
            return;
        }
        boolean hasCatalystNearby = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1)).anyMatch(neighborPos -> level.getBlockState(neighborPos).is(RNTags.Blocks.CRYSTALLIZATION_CATALYST));
        if (hasCatalystNearby) {
            this.getCrystallized(state).ifPresent(blockState -> level.setBlockAndUpdate(pos, blockState));
        } else {
            this.changeOverTime(state, level, pos, random);
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return TarnishingBronze.canCrystallize(state.getBlock());
    }

    public TarnishingBronze.TarnishState getAge() {
        return this.tarnishState;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.waxing(stack, state, level, pos, player, hand, hitResult) ? ItemInteractionResult.SUCCESS : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)((Boolean)state.getValue((Property)WAXED) != false ? (ItemLike)BuiltInRegistries.ITEM.get(RubinatedNether.id(WaxableBlockItem.getWaxableItem((ItemLike)this))) : this));
    }
}

