/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corundum.rubinated_nether.content.RNItems;
import corundum.rubinated_nether.content.RNTags;
import corundum.rubinated_nether.content.blocks.BronzeBulbBlock;
import corundum.rubinated_nether.content.blocks.TarnishingBronze;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TarnishingBronzeBulbBlock
extends BronzeBulbBlock
implements TarnishingBronze {
    public static final MapCodec<TarnishingBronzeBulbBlock> CODEC = RecordCodecBuilder.mapCodec(blockInstance -> blockInstance.group((App)TarnishingBronze.TarnishState.CODEC.fieldOf("tarnishing_state").forGetter(ChangeOverTimeBlock::getAge), (App)TarnishingBronzeBulbBlock.propertiesCodec()).apply((Applicative)blockInstance, TarnishingBronzeBulbBlock::new));
    private final TarnishingBronze.TarnishState tarnishState;

    protected MapCodec<TarnishingBronzeBulbBlock> codec() {
        return CODEC;
    }

    public TarnishingBronzeBulbBlock(TarnishingBronze.TarnishState tarnishState, BlockBehaviour.Properties properties) {
        super(properties, null, null);
        this.tarnishState = tarnishState;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WAXED, LIT, POWERED});
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.waxingBulb(stack, state, level, pos, player, hand, hitResult)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean waxingBulb(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Boolean waxed = (Boolean)state.getValue((Property)WAXED);
        if (stack.is(ItemTags.AXES)) {
            if (!waxed.booleanValue() && TarnishingBronze.getPrevious(state).isEmpty()) {
                return false;
            }
            stack.hurtAndBreak(1, (LivingEntity)player, null);
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (waxed.booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)), 2);
                level.levelEvent(player, 3004, pos, 0);
            } else {
                TarnishingBronze.getPrevious(state).ifPresent(newState -> {
                    BlockState finalState = newState;
                    try {
                        if (newState.hasProperty((Property)LIT)) {
                            finalState = (BlockState)finalState.setValue((Property)LIT, (Comparable)((Boolean)state.getValue((Property)LIT)));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        if (newState.hasProperty((Property)POWERED)) {
                            finalState = (BlockState)finalState.setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    level.setBlock(pos, finalState, 2);
                });
                level.levelEvent(player, 3005, pos, 0);
                if (!level.isClientSide() && level.random.nextFloat() < 0.5f) {
                    ItemEntity bronzeDrop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)RNItems.BRONZE_POWDER.get()));
                    bronzeDrop.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)bronzeDrop);
                }
            }
            return true;
        }
        if (stack.is((Item)RNItems.BRONZE_POWDER.get())) {
            Optional nextState = this.getNext(state);
            if (nextState.isPresent()) {
                BlockState newState2 = (BlockState)nextState.get();
                try {
                    if (newState2.hasProperty((Property)LIT)) {
                        newState2 = (BlockState)newState2.setValue((Property)LIT, (Comparable)((Boolean)state.getValue((Property)LIT)));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    if (newState2.hasProperty((Property)POWERED)) {
                        newState2 = (BlockState)newState2.setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    if (newState2.hasProperty((Property)WAXED)) {
                        newState2 = (BlockState)newState2.setValue((Property)WAXED, (Comparable)waxed);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                level.setBlock(pos, newState2, 2);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 0.8f);
                level.levelEvent(player, 3005, pos, 0);
                return true;
            }
            return false;
        }
        if (stack.is(Items.HONEYCOMB) && !waxed.booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WAXED, (Comparable)Boolean.valueOf(true)), 2);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3003, pos, 0);
            return true;
        }
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)WAXED)).booleanValue()) {
            return;
        }
        boolean hasCatalystNearby = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1)).anyMatch(neighborPos -> level.getBlockState(neighborPos).is(RNTags.Blocks.CRYSTALLIZATION_CATALYST));
        if (hasCatalystNearby) {
            this.getCrystallized(state).ifPresent(blockState -> level.setBlockAndUpdate(pos, blockState));
        } else {
            this.changeOverTime(state, level, pos, random);
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return TarnishingBronze.getNext(state.getBlock()).isPresent();
    }

    public TarnishingBronze.TarnishState getAge() {
        return this.tarnishState;
    }
}

