/*
 * Decompiled with CFR 0.152.
 */
package corundum.rubinated_nether.content.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import corundum.rubinated_nether.content.RNBlocks;
import corundum.rubinated_nether.content.RNDataMaps;
import corundum.rubinated_nether.content.RNItems;
import corundum.rubinated_nether.content.datamaps.Tarnishable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface TarnishingBronze
extends ChangeOverTimeBlock<TarnishState> {
    public static final BooleanProperty WAXED = BooleanProperty.create((String)"waxed");
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)RNBlocks.BRONZE_BLOCK.get()), (Object)((Block)RNBlocks.DISCOLORED_BRONZE_BLOCK.get())).put((Object)((Block)RNBlocks.DISCOLORED_BRONZE_BLOCK.get()), (Object)((Block)RNBlocks.CORRODED_BRONZE_BLOCK.get())).put((Object)((Block)RNBlocks.CORRODED_BRONZE_BLOCK.get()), (Object)((Block)RNBlocks.TARNISHED_BRONZE_BLOCK.get())).put((Object)((Block)RNBlocks.CUT_BRONZE_PILLAR.get()), (Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_PILLAR.get())).put((Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_PILLAR.get()), (Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_PILLAR.get())).put((Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_PILLAR.get()), (Object)((Block)RNBlocks.TARNISHED_CUT_BRONZE_PILLAR.get())).put((Object)((Block)RNBlocks.CUT_BRONZE_BRICKS.get()), (Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS.get())).put((Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS.get()), (Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS.get())).put((Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS.get()), (Object)((Block)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS.get())).put((Object)((Block)RNBlocks.CUT_BRONZE_BRICKS_STAIRS.get()), (Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_STAIRS.get())).put((Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_STAIRS.get()), (Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_STAIRS.get())).put((Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_STAIRS.get()), (Object)((Block)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS_STAIRS.get())).put((Object)((Block)RNBlocks.CUT_BRONZE_BRICKS_SLAB.get()), (Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_SLAB.get())).put((Object)((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_SLAB.get()), (Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_SLAB.get())).put((Object)((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_SLAB.get()), (Object)((Block)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS_SLAB.get())).put((Object)((Block)RNBlocks.BRONZE_BULB.get()), (Object)((Block)RNBlocks.DISCOLORED_BRONZE_BULB.get())).put((Object)((Block)RNBlocks.DISCOLORED_BRONZE_BULB.get()), (Object)((Block)RNBlocks.CORRODED_BRONZE_BULB.get())).put((Object)((Block)RNBlocks.CORRODED_BRONZE_BULB.get()), (Object)((Block)RNBlocks.TARNISHED_BRONZE_BULB.get())).build());
    public static final Supplier<Map<Block, Block>> CRYSTALLIZED_BY_BLOCK = Suppliers.memoize(() -> {
        HashMap<Block, Block> map = new HashMap<Block, Block>();
        map.put((Block)RNBlocks.BRONZE_BLOCK.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BLOCK.get());
        map.put((Block)RNBlocks.DISCOLORED_BRONZE_BLOCK.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BLOCK.get());
        map.put((Block)RNBlocks.CORRODED_BRONZE_BLOCK.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BLOCK.get());
        map.put((Block)RNBlocks.TARNISHED_BRONZE_BLOCK.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BLOCK.get());
        map.put((Block)RNBlocks.CUT_BRONZE_PILLAR.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_PILLAR.get());
        map.put((Block)RNBlocks.DISCOLORED_CUT_BRONZE_PILLAR.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_PILLAR.get());
        map.put((Block)RNBlocks.CORRODED_CUT_BRONZE_PILLAR.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_PILLAR.get());
        map.put((Block)RNBlocks.TARNISHED_CUT_BRONZE_PILLAR.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_PILLAR.get());
        map.put((Block)RNBlocks.CUT_BRONZE_BRICKS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS.get());
        map.put((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS.get());
        map.put((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS.get());
        map.put((Block)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS.get());
        map.put((Block)RNBlocks.CUT_BRONZE_BRICKS_STAIRS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_STAIRS.get());
        map.put((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_STAIRS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_STAIRS.get());
        map.put((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_STAIRS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_STAIRS.get());
        map.put((Block)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS_STAIRS.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_STAIRS.get());
        map.put((Block)RNBlocks.CUT_BRONZE_BRICKS_SLAB.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_SLAB.get());
        map.put((Block)RNBlocks.DISCOLORED_CUT_BRONZE_BRICKS_SLAB.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_SLAB.get());
        map.put((Block)RNBlocks.CORRODED_CUT_BRONZE_BRICKS_SLAB.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_SLAB.get());
        map.put((Block)RNBlocks.TARNISHED_CUT_BRONZE_BRICKS_SLAB.get(), (Block)RNBlocks.CRYSTALLIZED_CUT_BRONZE_BRICKS_SLAB.get());
        map.put((Block)RNBlocks.BRONZE_BULB.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BULB.get());
        map.put((Block)RNBlocks.DISCOLORED_BRONZE_BULB.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BULB.get());
        map.put((Block)RNBlocks.CORRODED_BRONZE_BULB.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BULB.get());
        map.put((Block)RNBlocks.TARNISHED_BRONZE_BULB.get(), (Block)RNBlocks.CRYSTALLIZED_BRONZE_BULB.get());
        return Collections.unmodifiableMap(map);
    });
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());
    public static final Map<Block, Block> INVERSE_TARNISHABLES_DATAMAP_INTERNAL = new HashMap<Block, Block>();
    public static final Map<Block, Block> INVERSE_TARNISHABLES_DATAMAP = Collections.unmodifiableMap(INVERSE_TARNISHABLES_DATAMAP_INTERNAL);

    public static Block getPreviousTarnishStage(Block block) {
        return INVERSE_TARNISHABLES_DATAMAP.containsKey(block) ? INVERSE_TARNISHABLES_DATAMAP.get(block) : (Block)PREVIOUS_BY_BLOCK.get().get((Object)block);
    }

    public static Optional<Block> getPrevious(Block block) {
        return Optional.ofNullable(TarnishingBronze.getPreviousTarnishStage(block));
    }

    public static Block getFirst(Block p_block) {
        Block block = p_block;
        Block block1 = TarnishingBronze.getPreviousTarnishStage(p_block);
        while (block1 != null) {
            block = block1;
            block1 = TarnishingBronze.getPreviousTarnishStage(block1);
        }
        return block;
    }

    public static Block getCrystallizedStage(Block p_block) {
        return CRYSTALLIZED_BY_BLOCK.get().getOrDefault(p_block, p_block);
    }

    public static Optional<Block> getCrystallized(Block block) {
        return Optional.ofNullable(TarnishingBronze.getCrystallizedStage(block));
    }

    default public Optional<BlockState> getCrystallized(BlockState state) {
        return TarnishingBronze.getCrystallized(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static boolean canCrystallize(Block p_block) {
        return CRYSTALLIZED_BY_BLOCK.get().get(p_block) != null;
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return TarnishingBronze.getPrevious(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Block getNextTarnishStage(Block block) {
        Tarnishable tarnishable = (Tarnishable)block.builtInRegistryHolder().getData(RNDataMaps.TARNISHABLES);
        return tarnishable != null ? tarnishable.nextTarnishmentStage() : (Block)NEXT_BY_BLOCK.get().get((Object)block);
    }

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable(TarnishingBronze.getNextTarnishStage(block));
    }

    public static BlockState getFirst(BlockState state) {
        return TarnishingBronze.getFirst(state.getBlock()).withPropertiesOf(state);
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return TarnishingBronze.getNext(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return this.getAge() == TarnishState.UNAFFECTED ? 0.75f : 1.0f;
    }

    default public boolean waxing(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Boolean waxed = (Boolean)state.getValue((Property)WAXED);
        if (stack.is(ItemTags.AXES)) {
            if (!waxed.booleanValue() && TarnishingBronze.getPrevious(state).isEmpty()) {
                return false;
            }
            stack.hurtAndBreak(1, (LivingEntity)player, null);
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (waxed.booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)), 2);
                level.levelEvent(player, 3004, pos, 0);
            } else {
                level.setBlock(pos, TarnishingBronze.getPrevious(state).get(), 2);
                level.levelEvent(player, 3005, pos, 0);
                if (!level.isClientSide() && level.random.nextFloat() < 0.5f) {
                    ItemEntity bronzeDrop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)RNItems.BRONZE_POWDER.get()));
                    bronzeDrop.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)bronzeDrop);
                }
            }
            return true;
        }
        if (stack.is((Item)RNItems.BRONZE_POWDER.get())) {
            Optional<BlockState> nextState = this.getNext(state);
            if (nextState.isPresent()) {
                level.setBlock(pos, nextState.get(), 2);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 0.8f);
                level.levelEvent(player, 3005, pos, 0);
                return true;
            }
            return false;
        }
        if (stack.is(Items.HONEYCOMB) && !waxed.booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WAXED, (Comparable)Boolean.valueOf(true)), 2);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3003, pos, 0);
            return true;
        }
        return false;
    }

    public static enum TarnishState implements StringRepresentable
    {
        UNAFFECTED("unaffected"),
        DISCOLORED("discolored"),
        CORRODED("corroded"),
        TARNISHED("tarnished"),
        CRYSTALLIZED("crystallized");

        public static final Codec<TarnishState> CODEC;
        private final String name;

        private TarnishState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TarnishState::values);
        }
    }
}

